/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.provider.J2EEBinaryModulesItemProvider;
import org.eclipse.jst.j2ee.internal.provider.J2EEItemProvider;
import org.eclipse.jst.j2ee.jca.modulecore.util.ConnectorArtifactEdit;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ModulesItemProvider
extends J2EEItemProvider {
    public static final String MODULES = J2EEUIMessages.getResourceString("Modules_UI_");
    private List localChildren = null;

    public ModulesItemProvider() {
    }

    public ModulesItemProvider(Collection children) {
        super(children);
    }

    public ModulesItemProvider(String text) {
        super(text);
    }

    public ModulesItemProvider(String text, Collection children) {
        super(text, children);
    }

    public ModulesItemProvider(String text, Object image) {
        super(text, image);
    }

    public ModulesItemProvider(String text, Object image, Collection children) {
        super(text, image, children);
    }

    public ModulesItemProvider(String text, Object image, Object parent) {
        super(text, image, parent);
    }

    public ModulesItemProvider(String text, Object image, Object parent, Collection children) {
        super(text, image, parent, children);
    }

    public ModulesItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public ModulesItemProvider(AdapterFactory adapterFactory, String text) {
        super(adapterFactory, text);
    }

    public ModulesItemProvider(AdapterFactory adapterFactory, String text, Object image) {
        super(adapterFactory, text, image);
    }

    public ModulesItemProvider(AdapterFactory adapterFactory, String text, Object image, Object parent) {
        super(adapterFactory, text, image, parent);
    }

    public ModulesItemProvider(AdapterFactory adapterFactory, Collection children) {
        super(adapterFactory, children);
    }

    public ModulesItemProvider(AdapterFactory adapterFactory, String text, Collection children) {
        super(adapterFactory, text, children);
    }

    public ModulesItemProvider(AdapterFactory adapterFactory, String text, Object image, Collection children) {
        super(adapterFactory, text, image, children);
    }

    public ModulesItemProvider(AdapterFactory adapterFactory, String text, Object image, Object parent, Collection children) {
        super(adapterFactory, text, image, parent, children);
    }

    public Object getImage(Object object) {
        return J2EEPlugin.getPlugin().getImage("folder");
    }

    public Application getParentApplication() {
        return (Application)this.getParent();
    }

    public IFile getAssociatedFile() {
        try {
            Application application = this.getParentApplication();
            if (application != null && application.eResource() != null) {
                return WorkbenchResourceHelperBase.getIFile((URI)application.eResource().getURI());
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public String getText(Object object) {
        return MODULES;
    }

    public boolean hasChildren(Object object) {
        this.getChildren(object);
        return !this.localChildren.isEmpty();
    }

    public Collection getChildren(Object object) {
        return this.initChildren(object);
    }

    protected List initChildren(Object object) {
        this.localChildren = new ArrayList();
        Application app = (Application)this.getParent();
        IVirtualComponent ear = ComponentUtilities.findComponent((EObject)app);
        EList modules = app.getModules();
        ArrayList<WebApp> binaryModules = new ArrayList<WebApp>();
        IVirtualReference[] refs = ear.getReferences();
        int i = 0;
        while (i < modules.size()) {
            Module module = (Module)modules.get(i);
            String moduleURI = module.getUri();
            boolean foundBinary = false;
            int j = 0;
            while (j < refs.length && !foundBinary) {
                IVirtualComponent component = refs[j].getReferencedComponent();
                if (component.isBinary() && refs[j].getArchiveName().equals(moduleURI)) {
                    WebArtifactEdit edit = null;
                    try {
                        ConnectorArtifactEdit connectorEdit;
                        foundBinary = true;
                        WebApp binaryModule = null;
                        if (module.isWebModule()) {
                            WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
                            if (webEdit != null) {
                                edit = webEdit;
                                binaryModule = webEdit.getWebApp();
                            }
                        } else if (module.isJavaModule()) {
                            AppClientArtifactEdit appClientEdit = AppClientArtifactEdit.getAppClientArtifactEditForRead((IVirtualComponent)component);
                            if (appClientEdit != null) {
                                edit = appClientEdit;
                                binaryModule = appClientEdit.getApplicationClient();
                            }
                        } else if (module.isEjbModule()) {
                            EJBArtifactEdit ejbEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
                            if (ejbEdit != null) {
                                edit = ejbEdit;
                                binaryModule = ejbEdit.getEJBJar();
                            }
                        } else if (module.isConnectorModule() && (connectorEdit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IVirtualComponent)component)) != null) {
                            edit = connectorEdit;
                            binaryModule = connectorEdit.getConnector();
                        }
                        if (binaryModule != null) {
                            binaryModules.add(binaryModule);
                        }
                    }
                    finally {
                        if (edit != null) {
                            edit.dispose();
                        }
                    }
                }
                ++j;
            }
            if (!foundBinary) {
                this.localChildren.add(module);
            }
            ++i;
        }
        if (!binaryModules.isEmpty()) {
            this.localChildren.add(new J2EEBinaryModulesItemProvider(app, this.getAdapterFactory(), binaryModules));
        }
        return this.localChildren;
    }
}

