/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.ExtensibilityElement;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class AP1902
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public AP1902(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            List extElems;
            String type;
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), entryContext.getMessageEntryDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            if ("request".equals(entryContext.getEntry().getEntryType())) {
                type = "input";
                extElems = bindingOperation.getBindingInput() == null ? null : bindingOperation.getBindingInput().getExtensibilityElements();
            } else {
                type = "output";
                List list = extElems = bindingOperation.getBindingOutput() == null ? null : bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (!this.usesMimeBinding(extElems) && entryContext.getMessageEntry().getMimeParts().count() > 1) {
                throw new AssertionFailException("The wsdl:" + type + " of the \"" + bindingOperation.getName() + "\" binding operation.");
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean usesMimeBinding(List extElems) {
        return extElems != null && extElems.size() > 0 && ((ExtensibilityElement)extElems.get(0)).getElementType().equals(WSDL_MIME_MULTIPART);
    }
}

