/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jpt.core.internal.AccessType;
import org.eclipse.jpt.core.internal.JpaCorePackage;
import org.eclipse.jpt.core.internal.JpaDataSource;
import org.eclipse.jpt.core.internal.JpaFile;
import org.eclipse.jpt.core.internal.JpaModel;
import org.eclipse.jpt.core.internal.JpaProject;
import org.eclipse.jpt.core.internal.NullTypeMapping;

public class JpaCoreFactory
extends EFactoryImpl {
    public static final JpaCoreFactory eINSTANCE = JpaCoreFactory.init();

    public static JpaCoreFactory init() {
        try {
            JpaCoreFactory theJpaCoreFactory = (JpaCoreFactory)EPackage.Registry.INSTANCE.getEFactory("jpt.core.xmi");
            if (theJpaCoreFactory != null) {
                return theJpaCoreFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new JpaCoreFactory();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createJpaModel();
            }
            case 5: {
                return this.createJpaProject();
            }
            case 8: {
                return this.createJpaDataSource();
            }
            case 10: {
                return this.createJpaFile();
            }
            case 18: {
                return this.createNullTypeMapping();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 21: {
                return this.createAccessTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 21: {
                return this.convertAccessTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public JpaModel createJpaModel() {
        JpaModel jpaModel = new JpaModel();
        return jpaModel;
    }

    public JpaProject createJpaProject() {
        JpaProject jpaProject = new JpaProject();
        return jpaProject;
    }

    public JpaDataSource createJpaDataSource() {
        JpaDataSource jpaDataSource = new JpaDataSource();
        return jpaDataSource;
    }

    public JpaFile createJpaFile() {
        JpaFile jpaFile = new JpaFile();
        return jpaFile;
    }

    public NullTypeMapping createNullTypeMapping() {
        NullTypeMapping nullTypeMapping = new NullTypeMapping();
        return nullTypeMapping;
    }

    public AccessType createAccessTypeFromString(EDataType eDataType, String initialValue) {
        AccessType result = AccessType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertAccessTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public JpaCorePackage getJpaCorePackage() {
        return (JpaCorePackage)this.getEPackage();
    }

    @Deprecated
    public static JpaCorePackage getPackage() {
        return JpaCorePackage.eINSTANCE;
    }
}

