/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jpt.core.internal.IJpaModel;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaCorePackage;
import org.eclipse.jpt.core.internal.JpaEObject;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.JpaProject;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaModel
extends JpaEObject
implements IJpaModel {
    protected EList<IJpaProject> projects;
    private boolean filled = false;

    protected JpaModel() {
    }

    @Override
    protected EClass eStaticClass() {
        return JpaCorePackage.Literals.JPA_MODEL;
    }

    public EList<IJpaProject> getProjects() {
        if (this.projects == null) {
            this.projects = new EObjectContainmentEList(IJpaProject.class, (InternalEObject)this, 0);
        }
        return this.projects;
    }

    @Override
    public synchronized IJpaProject getJpaProject(IProject project) {
        for (IJpaProject jpaProject : this.getProjects()) {
            if (!jpaProject.getProject().equals((Object)project)) continue;
            return jpaProject;
        }
        if (!this.filled) {
            try {
                return JpaModelManager.instance().createJpaProject(project);
            }
            catch (CoreException ce) {
                JptCorePlugin.log(ce.getStatus());
                return null;
            }
        }
        return null;
    }

    @Override
    public Iterator<IJpaProject> jpaProjects() {
        return new ReadOnlyIterator(this.getProjects().iterator());
    }

    @Override
    public IResource getResource() {
        return null;
    }

    void fill() throws CoreException {
        if (this.filled) {
            return;
        }
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy resourceProxy) throws CoreException {
                if (!resourceProxy.isAccessible()) {
                    return false;
                }
                switch (resourceProxy.getType()) {
                    case 8: {
                        return true;
                    }
                    case 4: {
                        JpaModelManager.instance().fillJpaProject((IProject)resourceProxy.requestResource());
                    }
                }
                return false;
            }
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor, 0);
        this.filled = true;
    }

    void dispose() {
        CloneIterator stream = new CloneIterator(this.getProjects());
        while (stream.hasNext()) {
            this.disposeProject((JpaProject)stream.next());
        }
    }

    void disposeProject(JpaProject jpaProject) {
        jpaProject.dispose();
        this.getProjects().remove((Object)jpaProject);
    }

    void handleEvent(ElementChangedEvent event) {
        Iterator stream = this.getProjects().iterator();
        while (stream.hasNext()) {
            ((JpaProject)stream.next()).handleEvent(event);
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getProjects()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getProjects();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getProjects().clear();
                this.getProjects().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getProjects().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.projects != null && !this.projects.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

