/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.core.internal.content.java.IJavaAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.IJavaAttributeMappingProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaBasic;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class JavaBasicProvider
implements IJavaAttributeMappingProvider {
    private static final JavaBasicProvider INSTANCE = new JavaBasicProvider();
    private static final String[] VALID_ELEMENT_TYPE_NAMES = new String[]{Byte.TYPE.getName(), Character.TYPE.getName(), Byte.class.getName(), Character.class.getName()};
    private static final String[] PRIMITIVE_WRAPPER_TYPE_NAMES = new String[]{Byte.class.getName(), Character.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), Boolean.class.getName()};
    private static final String[] OTHER_SUPPORTED_TYPE_NAMES = new String[]{String.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName()};
    private static final String SERIALIZABLE_TYPE_NAME = Serializable.class.getName();

    public static IJavaAttributeMappingProvider instance() {
        return INSTANCE;
    }

    private JavaBasicProvider() {
    }

    public String key() {
        return "basic";
    }

    public boolean defaultApplies(Attribute attribute, DefaultsContext defaultsContext) {
        return JavaBasicProvider.signatureIsBasic(attribute.typeSignature(), attribute.getDeclaringType().getJdtMember());
    }

    public IJavaAttributeMapping buildMapping(Attribute attribute) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaBasic(attribute);
    }

    public DeclarationAnnotationAdapter declarationAnnotationAdapter() {
        return JavaBasic.DECLARATION_ANNOTATION_ADAPTER;
    }

    public static boolean signatureIsBasic(String signature, IType scope) {
        if (JDTTools.signatureIsPrimitive(signature)) {
            return true;
        }
        int arrayCount = Signature.getArrayCount((String)signature);
        if (arrayCount > 1) {
            return false;
        }
        String typeName = JDTTools.resolveSignature(signature = Signature.getElementType((String)signature), scope);
        if (typeName == null) {
            return false;
        }
        if (arrayCount == 1) {
            return JavaBasicProvider.elementTypeIsValid(typeName);
        }
        if (JavaBasicProvider.typeIsPrimitiveWrapper(typeName)) {
            return true;
        }
        if (JavaBasicProvider.typeIsOtherSupportedType(typeName)) {
            return true;
        }
        IType type = JavaBasicProvider.findType(scope.getCompilationUnit().getJavaProject(), typeName);
        if (type == null) {
            return false;
        }
        if (JavaBasicProvider.typeIsEnum(type)) {
            return true;
        }
        return JavaBasicProvider.typeImplementsSerializable(type);
    }

    private static IType findType(IJavaProject javaProject, String typeName) {
        try {
            return javaProject.findType(typeName);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean elementTypeIsValid(String elementTypeName) {
        return CollectionTools.contains((Object[])VALID_ELEMENT_TYPE_NAMES, (Object)elementTypeName);
    }

    private static boolean typeIsPrimitiveWrapper(String typeName) {
        return CollectionTools.contains((Object[])PRIMITIVE_WRAPPER_TYPE_NAMES, (Object)typeName);
    }

    private static boolean typeIsOtherSupportedType(String typeName) {
        return CollectionTools.contains((Object[])OTHER_SUPPORTED_TYPE_NAMES, (Object)typeName);
    }

    private static boolean typeIsEnum(IType type) {
        try {
            return type.isEnum();
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean typeImplementsSerializable(IType type) {
        ITypeHierarchy hierarchy = JavaBasicProvider.typeHierarchy(type);
        IType[] interfaces = hierarchy.getAllSuperInterfaces(type);
        int i = interfaces.length;
        while (i-- > 0) {
            if (!interfaces[i].getFullyQualifiedName().equals(SERIALIZABLE_TYPE_NAME)) continue;
            return true;
        }
        return false;
    }

    private static ITypeHierarchy typeHierarchy(IType type) {
        try {
            return type.newSupertypeHierarchy(null, null);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }
}

