/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.content.java.mappings.AbstractJavaColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.IntAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.mappings.INamedColumn;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaColumn
extends AbstractJavaColumn
implements IColumn {
    protected static final int LENGTH_EDEFAULT = 255;
    protected int length = 255;
    protected static final int PRECISION_EDEFAULT = 0;
    protected int precision = 0;
    protected static final int SCALE_EDEFAULT = 0;
    protected int scale = 0;
    private final IntAnnotationElementAdapter lengthAdapter;
    private final IntAnnotationElementAdapter precisionAdapter;
    private final IntAnnotationElementAdapter scaleAdapter;
    public static final SimpleDeclarationAnnotationAdapter MAPPING_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Column");

    protected JavaColumn() {
        throw new UnsupportedOperationException("Use JavaColumn(Owner, Member, DeclarationAnnotationAdapter) instead");
    }

    protected JavaColumn(INamedColumn.Owner owner, Member member, DeclarationAnnotationAdapter daa) {
        super(owner, member, daa);
        this.lengthAdapter = this.buildShortCircuitIntElementAdapter("length");
        this.precisionAdapter = this.buildShortCircuitIntElementAdapter("precision");
        this.scaleAdapter = this.buildShortCircuitIntElementAdapter("scale");
    }

    @Override
    protected String nameElementName() {
        return "name";
    }

    @Override
    protected String columnDefinitionElementName() {
        return "columnDefinition";
    }

    @Override
    protected String tableElementName() {
        return "table";
    }

    @Override
    protected String uniqueElementName() {
        return "unique";
    }

    @Override
    protected String nullableElementName() {
        return "nullable";
    }

    @Override
    protected String insertableElementName() {
        return "insertable";
    }

    @Override
    protected String updatableElementName() {
        return "updatable";
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IColumn.class)) {
            case 11: {
                this.lengthAdapter.setValue(notification.getNewIntValue());
                break;
            }
            case 12: {
                this.precisionAdapter.setValue(notification.getNewIntValue());
                break;
            }
            case 13: {
                this.scaleAdapter.setValue(notification.getNewIntValue());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_COLUMN;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int newLength) {
        int oldLength = this.length;
        this.length = newLength;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldLength, this.length));
        }
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(int newPrecision) {
        int oldPrecision = this.precision;
        this.precision = newPrecision;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldPrecision, this.precision));
        }
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setScale(int newScale) {
        int oldScale = this.scale;
        this.scale = newScale;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldScale, this.scale));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return new Integer(this.getLength());
            }
            case 12: {
                return new Integer(this.getPrecision());
            }
            case 13: {
                return new Integer(this.getScale());
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setLength((Integer)newValue);
                return;
            }
            case 12: {
                this.setPrecision((Integer)newValue);
                return;
            }
            case 13: {
                this.setScale((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setLength(255);
                return;
            }
            case 12: {
                this.setPrecision(0);
                return;
            }
            case 13: {
                this.setScale(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.length != 255;
            }
            case 12: {
                return this.precision != 0;
            }
            case 13: {
                return this.scale != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IColumn.class) {
            switch (derivedFeatureID) {
                case 11: {
                    return 11;
                }
                case 12: {
                    return 12;
                }
                case 13: {
                    return 13;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IColumn.class) {
            switch (baseFeatureID) {
                case 11: {
                    return 11;
                }
                case 12: {
                    return 12;
                }
                case 13: {
                    return 13;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (length: ");
        result.append(this.length);
        result.append(", precision: ");
        result.append(this.precision);
        result.append(", scale: ");
        result.append(this.scale);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean tableIsAllowed() {
        return true;
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setLength(this.lengthAdapter.getValue(astRoot));
        this.setPrecision(this.precisionAdapter.getValue(astRoot));
        this.setScale(this.scaleAdapter.getValue(astRoot));
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        this.setDefaultTable((String)defaultsContext.getDefault("column.table"));
        this.setDefaultName((String)defaultsContext.getDefault("column.name"));
    }

    static JavaColumn createColumnMappingColumn(INamedColumn.Owner owner, Member member) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaColumn(owner, member, MAPPING_DECLARATION_ANNOTATION_ADAPTER);
    }

    static JavaColumn createAttributeOverrideColumn(INamedColumn.Owner owner, Member member, DeclarationAnnotationAdapter attributeOverrideAnnotationAdapter) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaColumn(owner, member, JavaColumn.buildAttributeOverrideAnnotationAdapter(attributeOverrideAnnotationAdapter));
    }

    private static DeclarationAnnotationAdapter buildAttributeOverrideAnnotationAdapter(DeclarationAnnotationAdapter attributeOverrideAnnotationAdapter) {
        return new NestedDeclarationAnnotationAdapter(attributeOverrideAnnotationAdapter, "column", "javax.persistence.Column");
    }
}

