/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.orm;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmPackage;
import org.eclipse.jpt.core.internal.content.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IEmbeddable;
import org.eclipse.jpt.core.internal.mappings.IEmbedded;
import org.eclipse.jpt.core.internal.mappings.IOverride;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEmbedded
extends XmlAttributeMapping
implements IEmbedded {
    protected EList<IAttributeOverride> specifiedAttributeOverrides;
    protected EList<IAttributeOverride> defaultAttributeOverrides;
    private IEmbeddable embeddable;

    protected XmlEmbedded() {
    }

    @Override
    protected void addInsignificantFeatureIdsTo(Set<Integer> insignificantFeatureIds) {
        super.addInsignificantFeatureIdsTo(insignificantFeatureIds);
        insignificantFeatureIds.add(1);
    }

    @Override
    protected void initializeOn(XmlAttributeMapping newMapping) {
        newMapping.initializeFromXmlEmbeddedMapping(this);
    }

    @Override
    protected EClass eStaticClass() {
        return OrmPackage.Literals.XML_EMBEDDED;
    }

    @Override
    public EList<IAttributeOverride> getAttributeOverrides() {
        EObjectEList list = new EObjectEList(IAttributeOverride.class, (InternalEObject)this, 1);
        list.addAll(this.getSpecifiedAttributeOverrides());
        list.addAll(this.getDefaultAttributeOverrides());
        return list;
    }

    @Override
    public EList<IAttributeOverride> getSpecifiedAttributeOverrides() {
        if (this.specifiedAttributeOverrides == null) {
            this.specifiedAttributeOverrides = new EObjectContainmentEList(IAttributeOverride.class, (InternalEObject)this, 2);
        }
        return this.specifiedAttributeOverrides;
    }

    @Override
    public EList<IAttributeOverride> getDefaultAttributeOverrides() {
        if (this.defaultAttributeOverrides == null) {
            this.defaultAttributeOverrides = new EObjectContainmentEList(IAttributeOverride.class, (InternalEObject)this, 3);
        }
        return this.defaultAttributeOverrides;
    }

    @Override
    public IEmbeddable embeddable() {
        return this.embeddable;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getSpecifiedAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getDefaultAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getAttributeOverrides();
            }
            case 2: {
                return this.getSpecifiedAttributeOverrides();
            }
            case 3: {
                return this.getDefaultAttributeOverrides();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getSpecifiedAttributeOverrides().clear();
                this.getSpecifiedAttributeOverrides().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getDefaultAttributeOverrides().clear();
                this.getDefaultAttributeOverrides().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getSpecifiedAttributeOverrides().clear();
                return;
            }
            case 3: {
                this.getDefaultAttributeOverrides().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return !this.getAttributeOverrides().isEmpty();
            }
            case 2: {
                return this.specifiedAttributeOverrides != null && !this.specifiedAttributeOverrides.isEmpty();
            }
            case 3: {
                return this.defaultAttributeOverrides != null && !this.defaultAttributeOverrides.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IEmbedded.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IEmbedded.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public int xmlSequence() {
        return 7;
    }

    @Override
    public String getKey() {
        return "embedded";
    }

    @Override
    public IAttributeOverride attributeOverrideNamed(String name) {
        return (IAttributeOverride)this.overrideNamed(name, (List<? extends IOverride>)this.getAttributeOverrides());
    }

    @Override
    public boolean containsAttributeOverride(String name) {
        return this.containsOverride(name, (List<? extends IOverride>)this.getAttributeOverrides());
    }

    @Override
    public boolean containsSpecifiedAttributeOverride(String name) {
        return this.containsOverride(name, (List<? extends IOverride>)this.getSpecifiedAttributeOverrides());
    }

    private IOverride overrideNamed(String name, List<? extends IOverride> overrides) {
        for (IOverride iOverride : overrides) {
            String overrideName = iOverride.getName();
            if (overrideName == null && name == null) {
                return iOverride;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return iOverride;
        }
        return null;
    }

    private boolean containsOverride(String name, List<? extends IOverride> overrides) {
        return this.overrideNamed(name, overrides) != null;
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return new TransformationIterator<IPersistentAttribute, String>(this.allOverridableAttributes()){

            protected String transform(IPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    public Iterator<IPersistentAttribute> allOverridableAttributes() {
        if (this.embeddable() == null) {
            return EmptyIterator.instance();
        }
        return new FilteringIterator<IPersistentAttribute>(this.embeddable().getPersistentType().attributes()){

            protected boolean accept(Object o) {
                return ((IPersistentAttribute)o).isOverridableAttribute();
            }
        };
    }

    @Override
    public IAttributeOverride createAttributeOverride(int index) {
        return OrmFactory.eINSTANCE.createXmlAttributeOverride(new IEmbedded.AttributeOverrideOwner(this));
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        this.refreshEmbeddable(defaultsContext);
    }

    private void refreshEmbeddable(DefaultsContext defaultsContext) {
        this.embeddable = XmlEmbedded.embeddableFor(this.getPersistentAttribute().getAttribute(), defaultsContext);
    }

    public static IEmbeddable embeddableFor(Attribute attribute, DefaultsContext defaultsContext) {
        if (attribute == null) {
            return null;
        }
        String resolvedTypeName = attribute.resolvedTypeName();
        if (resolvedTypeName == null) {
            return null;
        }
        IPersistentType persistentType = defaultsContext.persistentType(resolvedTypeName);
        if (persistentType != null && persistentType.getMapping() instanceof IEmbeddable) {
            return (IEmbeddable)persistentType.getMapping();
        }
        return null;
    }
}

