/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldAttribute
extends Attribute {
    public FieldAttribute(IField field) {
        super((IMember)field);
    }

    public IField getJdtMember() {
        return (IField)super.getJdtMember();
    }

    public FieldDeclaration bodyDeclaration() {
        return (FieldDeclaration)super.bodyDeclaration();
    }

    public FieldDeclaration bodyDeclaration(CompilationUnit astRoot) {
        String fieldName = this.getName();
        FieldDeclaration[] fieldDeclarationArray = this.declaringTypeDeclaration(astRoot).getFields();
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : this.fragments(fieldDeclaration)) {
                if (!fragment.getName().getFullyQualifiedName().equals(fieldName)) continue;
                return fieldDeclaration;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public String attributeName() {
        return this.getName();
    }

    @Override
    public String typeSignature() {
        try {
            return this.getJdtMember().getTypeSignature();
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }
}

