/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.SimpleTextRange;
import org.eclipse.jpt.core.internal.jdtutility.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationEditFormatter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.core.internal.jdtutility.ModifiedDeclaration;
import org.eclipse.jpt.core.internal.jdtutility.Type;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Member {
    private final IMember jdtMember;
    private final Type declaringType;

    Member(IMember jdtMember) {
        this.jdtMember = jdtMember;
        IType jdtDeclaringType = jdtMember.getDeclaringType();
        this.declaringType = jdtDeclaringType == null ? null : new Type(jdtDeclaringType);
    }

    public IMember getJdtMember() {
        return this.jdtMember;
    }

    public boolean wraps(IMember member) {
        return this.jdtMember.exists() && this.jdtMember.equals(member);
    }

    public Type getDeclaringType() {
        return this.declaringType;
    }

    public ICompilationUnit compilationUnit() {
        return this.jdtMember.getCompilationUnit();
    }

    public String getName() {
        return this.jdtMember.getElementName();
    }

    public Type topLevelDeclaringType() {
        return this.declaringType.topLevelDeclaringType();
    }

    public CompilationUnit astRoot() {
        return JDTTools.createASTRoot(this.jdtMember);
    }

    public ModifiedDeclaration modifiedDeclaration() {
        return this.modifiedDeclaration(this.astRoot());
    }

    public ModifiedDeclaration modifiedDeclaration(CompilationUnit astRoot) {
        return new ModifiedDeclaration(this.bodyDeclaration(astRoot));
    }

    public BodyDeclaration bodyDeclaration() {
        return this.bodyDeclaration(this.astRoot());
    }

    public ITextRange textRange() {
        return this.textRange(this.astRoot());
    }

    public ITextRange textRange(CompilationUnit astRoot) {
        return this.textRange((ASTNode)this.bodyDeclaration(astRoot));
    }

    ITextRange textRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    public ITextRange nameTextRange() {
        return this.nameTextRange(this.astRoot());
    }

    public ITextRange nameTextRange(CompilationUnit astRoot) {
        ISourceRange sourceRange = this.nameSourceRange();
        return new SimpleTextRange(sourceRange.getOffset(), sourceRange.getLength(), astRoot.getLineNumber(sourceRange.getOffset()));
    }

    private ISourceRange nameSourceRange() {
        try {
            return this.getJdtMember().getNameRange();
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    TypeDeclaration declaringTypeDeclaration(CompilationUnit astRoot) {
        return this.declaringType.bodyDeclaration(astRoot);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    public abstract BodyDeclaration bodyDeclaration(CompilationUnit var1);

    public Annotation annotation(DeclarationAnnotationAdapter adapter, CompilationUnit astRoot) {
        return adapter.getAnnotation(this.modifiedDeclaration(astRoot));
    }

    public Annotation annotation(DeclarationAnnotationAdapter adapter) {
        return this.annotation(adapter, this.astRoot());
    }

    public boolean containsAnnotation(DeclarationAnnotationAdapter adapter, CompilationUnit astRoot) {
        return this.annotation(adapter, astRoot) != null;
    }

    public boolean containsAnnotation(DeclarationAnnotationAdapter adapter) {
        return this.containsAnnotation(adapter, this.astRoot());
    }

    public boolean containsAnyAnnotation(DeclarationAnnotationAdapter[] adapters) {
        return this.containsAnyAnnotation(adapters, this.astRoot());
    }

    public boolean containsAnyAnnotation(DeclarationAnnotationAdapter[] adapters, CompilationUnit astRoot) {
        DeclarationAnnotationAdapter[] declarationAnnotationAdapterArray = adapters;
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            DeclarationAnnotationAdapter adapter = declarationAnnotationAdapterArray[n2];
            if (this.containsAnnotation(adapter, astRoot)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ITextRange annotationTextRange(DeclarationAnnotationAdapter adapter, CompilationUnit astRoot) {
        return this.textRange((ASTNode)this.annotation(adapter, astRoot));
    }

    public ITextRange annotationTextRange(DeclarationAnnotationAdapter adapter) {
        return this.annotationTextRange(adapter, this.astRoot());
    }

    public ASTNode annotationASTNode(DeclarationAnnotationAdapter adapter, CompilationUnit astRoot) {
        return adapter.astNode(this.modifiedDeclaration(astRoot));
    }

    public ASTNode annotationASTNode(DeclarationAnnotationAdapter adapter) {
        return this.annotationASTNode(adapter, this.astRoot());
    }

    public void newMarkerAnnotation(final DeclarationAnnotationAdapter adapter) {
        this.edit(new Editor(){

            public void edit(ModifiedDeclaration declaration) {
                adapter.newMarkerAnnotation(declaration);
            }
        });
    }

    public void newSingleMemberAnnotation(final DeclarationAnnotationAdapter adapter) {
        this.edit(new Editor(){

            public void edit(ModifiedDeclaration declaration) {
                adapter.newSingleMemberAnnotation(declaration);
            }
        });
    }

    public void newNormalAnnotation(final DeclarationAnnotationAdapter adapter) {
        this.edit(new Editor(){

            public void edit(ModifiedDeclaration declaration) {
                adapter.newNormalAnnotation(declaration);
            }
        });
    }

    public void removeAnnotation(final DeclarationAnnotationAdapter adapter) {
        this.edit(new Editor(){

            public void edit(ModifiedDeclaration declaration) {
                adapter.removeAnnotation(declaration);
            }
        });
    }

    public <T> T annotationElementValue(DeclarationAnnotationElementAdapter<T> adapter, CompilationUnit astRoot) {
        return adapter.getValue(this.modifiedDeclaration(astRoot));
    }

    public <T> T annotationElementValue(DeclarationAnnotationElementAdapter<T> adapter) {
        return this.annotationElementValue(adapter, this.astRoot());
    }

    public Expression annotationElementExpression(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return adapter.expression(this.modifiedDeclaration(astRoot));
    }

    public Expression annotationElementExpression(DeclarationAnnotationElementAdapter<?> adapter) {
        return this.annotationElementExpression(adapter, this.astRoot());
    }

    public boolean containsAnnotationElement(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return this.annotationElementExpression(adapter, astRoot) != null;
    }

    public boolean containsAnnotationElement(DeclarationAnnotationElementAdapter<?> adapter) {
        return this.containsAnnotationElement(adapter, this.astRoot());
    }

    public ITextRange annotationElementTextRange(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return this.textRange((ASTNode)this.annotationElementExpression(adapter, astRoot));
    }

    public ITextRange annotationElementTextRange(DeclarationAnnotationElementAdapter<?> adapter) {
        return this.annotationElementTextRange(adapter, this.astRoot());
    }

    public ASTNode annotationElementASTNode(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return adapter.astNode(this.modifiedDeclaration(astRoot));
    }

    public ASTNode annotationElementASTNode(DeclarationAnnotationElementAdapter<?> adapter) {
        return this.annotationElementASTNode(adapter, this.astRoot());
    }

    public <T> void setAnnotationElementValue(final DeclarationAnnotationElementAdapter<T> adapter, final T value) {
        this.edit(new Editor(){

            public void edit(ModifiedDeclaration declaration) {
                adapter.setValue(value, declaration);
            }
        });
    }

    public void edit(Editor editor) {
        try {
            this.edit_(editor);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void edit_(Editor editor) throws JavaModelException, BadLocationException {
        ITextFileBuffer buffer;
        ICompilationUnit compilationUnit = this.compilationUnit();
        if (!compilationUnit.isWorkingCopy()) {
            compilationUnit.becomeWorkingCopy(null);
        }
        boolean textEditorPresent = (buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(compilationUnit.getResource().getFullPath())) != null;
        IDocument doc = textEditorPresent ? buffer.getDocument() : new Document(compilationUnit.getBuffer().getContents());
        CompilationUnit astRoot = this.astRoot();
        astRoot.recordModifications();
        editor.edit(this.modifiedDeclaration(astRoot));
        TextEdit edits = astRoot.rewrite(doc, compilationUnit.getJavaProject().getOptions(true));
        AnnotationEditFormatter formatter = new AnnotationEditFormatter(doc);
        formatter.apply(edits);
        if (!textEditorPresent) {
            compilationUnit.getBuffer().setContents(doc.get());
            compilationUnit.commitWorkingCopy(true, null);
            compilationUnit.discardWorkingCopy();
        }
    }

    public static interface Editor {
        public void edit(ModifiedDeclaration var1);
    }
}

