/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.mappings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DefaultEagerFetchType implements Enumerator
{
    DEFAULT(0, "Default", "Default (Eager)"),
    EAGER(1, "EAGER", "Eager"),
    LAZY(2, "LAZY", "Lazy");

    public static final int DEFAULT_VALUE = 0;
    public static final int EAGER_VALUE = 1;
    public static final int LAZY_VALUE = 2;
    private static final DefaultEagerFetchType[] VALUES_ARRAY;
    public static final List<DefaultEagerFetchType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DefaultEagerFetchType[]{DEFAULT, EAGER, LAZY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DefaultEagerFetchType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DefaultEagerFetchType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DefaultEagerFetchType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DefaultEagerFetchType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DefaultEagerFetchType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return EAGER;
            }
            case 2: {
                return LAZY;
            }
        }
        return null;
    }

    private DefaultEagerFetchType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static DefaultEagerFetchType fromJavaAnnotationValue(Object javaAnnotationValue) {
        if (javaAnnotationValue == null) {
            return DEFAULT;
        }
        if (javaAnnotationValue.equals("javax.persistence.FetchType.EAGER")) {
            return EAGER;
        }
        if (javaAnnotationValue.equals("javax.persistence.FetchType.LAZY")) {
            return LAZY;
        }
        return DEFAULT;
    }

    public String convertToJavaAnnotationValue() {
        switch (this.getValue()) {
            case 0: {
                return null;
            }
            case 1: {
                return "javax.persistence.FetchType.EAGER";
            }
            case 2: {
                return "javax.persistence.FetchType.LAZY";
            }
        }
        throw new IllegalArgumentException("unknown fetch type: " + (Object)((Object)this));
    }
}

