/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.mappings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DiscriminatorType implements Enumerator
{
    DEFAULT(0, "Default", "Default (String)"),
    STRING(1, "STRING", "String"),
    CHAR(2, "CHAR", "Char"),
    INTEGER(3, "INTEGER", "Integer");

    public static final int DEFAULT_VALUE = 0;
    public static final int STRING_VALUE = 1;
    public static final int CHAR_VALUE = 2;
    public static final int INTEGER_VALUE = 3;
    private static final DiscriminatorType[] VALUES_ARRAY;
    public static final List<DiscriminatorType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DiscriminatorType[]{DEFAULT, STRING, CHAR, INTEGER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DiscriminatorType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DiscriminatorType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DiscriminatorType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DiscriminatorType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DiscriminatorType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return STRING;
            }
            case 2: {
                return CHAR;
            }
            case 3: {
                return INTEGER;
            }
        }
        return null;
    }

    private DiscriminatorType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static DiscriminatorType fromJavaAnnotationValue(Object javaAnnotationValue) {
        if (javaAnnotationValue == null) {
            return DEFAULT;
        }
        if (javaAnnotationValue.equals("javax.persistence.DiscriminatorType.CHAR")) {
            return CHAR;
        }
        if (javaAnnotationValue.equals("javax.persistence.DiscriminatorType.INTEGER")) {
            return INTEGER;
        }
        if (javaAnnotationValue.equals("javax.persistence.DiscriminatorType.STRING")) {
            return STRING;
        }
        return DEFAULT;
    }

    public String convertToJavaAnnotationValue() {
        switch (this.getValue()) {
            case 0: {
                return null;
            }
            case 2: {
                return "javax.persistence.DiscriminatorType.CHAR";
            }
            case 3: {
                return "javax.persistence.DiscriminatorType.INTEGER";
            }
            case 1: {
                return "javax.persistence.DiscriminatorType.STRING";
            }
        }
        throw new IllegalArgumentException("unknown discriminator type: " + (Object)((Object)this));
    }

    public boolean isString() {
        return this.getValue() == 0 || this.getValue() == 1;
    }
}

