/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.mappings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GenerationType implements Enumerator
{
    DEFAULT(0, "Default", "Default (Auto)"),
    AUTO(1, "AUTO", "Auto"),
    IDENTITY(2, "IDENTITY", "Identity"),
    SEQUENCE(3, "SEQUENCE", "Sequence"),
    TABLE(4, "TABLE", "Table");

    public static final int DEFAULT_VALUE = 0;
    public static final int AUTO_VALUE = 1;
    public static final int IDENTITY_VALUE = 2;
    public static final int SEQUENCE_VALUE = 3;
    public static final int TABLE_VALUE = 4;
    private static final GenerationType[] VALUES_ARRAY;
    public static final List<GenerationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GenerationType[]{DEFAULT, AUTO, IDENTITY, SEQUENCE, TABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GenerationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenerationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenerationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenerationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenerationType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return AUTO;
            }
            case 2: {
                return IDENTITY;
            }
            case 3: {
                return SEQUENCE;
            }
            case 4: {
                return TABLE;
            }
        }
        return null;
    }

    private GenerationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static GenerationType fromJavaAnnotationValue(Object javaAnnotationValue) {
        if (javaAnnotationValue == null) {
            return DEFAULT;
        }
        if (javaAnnotationValue.equals("javax.persistence.GenerationType.AUTO")) {
            return AUTO;
        }
        if (javaAnnotationValue.equals("javax.persistence.GenerationType.IDENTITY")) {
            return IDENTITY;
        }
        if (javaAnnotationValue.equals("javax.persistence.GenerationType.SEQUENCE")) {
            return SEQUENCE;
        }
        if (javaAnnotationValue.equals("javax.persistence.GenerationType.TABLE")) {
            return TABLE;
        }
        return DEFAULT;
    }

    public String convertToJavaAnnotationValue() {
        switch (this.getValue()) {
            case 0: {
                return null;
            }
            case 1: {
                return "javax.persistence.GenerationType.AUTO";
            }
            case 2: {
                return "javax.persistence.GenerationType.IDENTITY";
            }
            case 3: {
                return "javax.persistence.GenerationType.SEQUENCE";
            }
            case 4: {
                return "javax.persistence.GenerationType.TABLE";
            }
        }
        throw new IllegalArgumentException("unknown generation type: " + (Object)((Object)this));
    }
}

