/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaBasic;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.platform.ColumnContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaAttributeContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBasicContext
extends JavaAttributeContext {
    private ColumnContext columnContext;

    public JavaBasicContext(IContext parentContext, JavaBasic javaBasic) {
        super(parentContext, javaBasic);
        this.columnContext = new ColumnContext(this, javaBasic.getColumn());
    }

    protected JavaBasic getBasic() {
        return (JavaBasic)this.attributeMapping;
    }

    @Override
    public void refreshDefaultsInternal(DefaultsContext defaultsContext) {
        super.refreshDefaultsInternal(defaultsContext);
        this.columnContext.refreshDefaults(defaultsContext);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addColumnMessages(messages);
    }

    protected void addColumnMessages(List<IMessage> messages) {
        boolean doContinue;
        JavaBasic basic = this.getBasic();
        ITypeMapping typeMapping = basic.typeMapping();
        IColumn column = basic.getColumn();
        String table = column.getTable();
        boolean bl = doContinue = this.entityOwned() && column.isConnected();
        if (doContinue && typeMapping.tableNameIsInvalid(table)) {
            messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.tableTextRange()));
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.nameTextRange()));
        }
    }
}

