/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEntity;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOverride;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.mappings.IAssociationOverride;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.mappings.ISecondaryTable;
import org.eclipse.jpt.core.internal.mappings.ISequenceGenerator;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.mappings.ITableGenerator;
import org.eclipse.jpt.core.internal.platform.AssociationOverrideContext;
import org.eclipse.jpt.core.internal.platform.AttributeOverrideContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.GeneratorRepository;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaTypeContext;
import org.eclipse.jpt.core.internal.platform.PrimaryKeyJoinColumnContext;
import org.eclipse.jpt.core.internal.platform.SecondaryTableContext;
import org.eclipse.jpt.core.internal.platform.TableContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEntityContext
extends JavaTypeContext {
    private TableContext tableContext;
    private Collection<SecondaryTableContext> secondaryTableContexts;
    private Collection<AttributeOverrideContext> attributeOverrideContexts;
    private Collection<AssociationOverrideContext> associationOverrideContexts;
    private Collection<PrimaryKeyJoinColumnContext> pkJoinColumnContexts;

    public JavaEntityContext(IContext parentContext, JavaEntity javaEntity) {
        super(parentContext, javaEntity);
        this.tableContext = this.buildTableContext(javaEntity);
        this.attributeOverrideContexts = this.buildAttributeOverrideContexts();
        this.associationOverrideContexts = this.buildAssociationOverrideContexts();
        this.secondaryTableContexts = this.buildSecondaryTableContexts();
        this.pkJoinColumnContexts = this.buildPkJoinColumnContexts();
    }

    protected JavaEntity getEntity() {
        return (JavaEntity)this.getTypeMapping();
    }

    protected TableContext buildTableContext(JavaEntity javaEntity) {
        return new TableContext(this, javaEntity.getTable());
    }

    protected Collection<AttributeOverrideContext> buildAttributeOverrideContexts() {
        ArrayList<AttributeOverrideContext> contexts = new ArrayList<AttributeOverrideContext>();
        for (IAttributeOverride attributeOverride : this.getEntity().getAttributeOverrides()) {
            contexts.add(new AttributeOverrideContext(this, attributeOverride));
        }
        return contexts;
    }

    protected Collection<AssociationOverrideContext> buildAssociationOverrideContexts() {
        ArrayList<AssociationOverrideContext> contexts = new ArrayList<AssociationOverrideContext>();
        for (IAssociationOverride associationOverride : this.getEntity().getDefaultAssociationOverrides()) {
            contexts.add(new AssociationOverrideContext(this, associationOverride));
        }
        return contexts;
    }

    protected Collection<SecondaryTableContext> buildSecondaryTableContexts() {
        ArrayList<SecondaryTableContext> contexts = new ArrayList<SecondaryTableContext>();
        for (ISecondaryTable secondaryTable : this.getEntity().getSecondaryTables()) {
            contexts.add(new SecondaryTableContext(this, secondaryTable));
        }
        return contexts;
    }

    protected Collection<PrimaryKeyJoinColumnContext> buildPkJoinColumnContexts() {
        ArrayList<PrimaryKeyJoinColumnContext> contexts = new ArrayList<PrimaryKeyJoinColumnContext>();
        for (IPrimaryKeyJoinColumn pkJoinColumn : this.getEntity().getPrimaryKeyJoinColumns()) {
            contexts.add(new PrimaryKeyJoinColumnContext((IContext)this, pkJoinColumn));
        }
        return contexts;
    }

    @Override
    protected void populateGeneratorRepository(GeneratorRepository generatorRepository) {
        ISequenceGenerator sequenceGenerator;
        super.populateGeneratorRepository(generatorRepository);
        ITableGenerator tableGenerator = this.getEntity().getTableGenerator();
        if (tableGenerator != null) {
            generatorRepository.addGenerator(tableGenerator);
        }
        if ((sequenceGenerator = this.getEntity().getSequenceGenerator()) != null) {
            generatorRepository.addGenerator(sequenceGenerator);
        }
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        defaultsContext = this.wrapDefaultsContext(defaultsContext);
        super.refreshDefaults(defaultsContext);
        if (this.tableContext != null) {
            this.tableContext.refreshDefaults(defaultsContext);
        }
        this.refreshDefaultAttributeOverrides();
        this.refreshDefaultAssociationOverrides();
        for (SecondaryTableContext secondaryTableContext : this.secondaryTableContexts) {
            secondaryTableContext.refreshDefaults(defaultsContext);
        }
        for (AttributeOverrideContext attributeOverrideContext : this.attributeOverrideContexts) {
            attributeOverrideContext.refreshDefaults(defaultsContext);
        }
        for (AssociationOverrideContext associationOverrideContext : this.associationOverrideContexts) {
            associationOverrideContext.refreshDefaults(defaultsContext);
        }
        for (PrimaryKeyJoinColumnContext primaryKeyJoinColumnContext : this.pkJoinColumnContexts) {
            primaryKeyJoinColumnContext.refreshDefaults(defaultsContext);
        }
    }

    public DefaultsContext wrapDefaultsContext(final DefaultsContext defaultsContext) {
        DefaultsContext wrappedDefaultsContext = new DefaultsContext(){

            public Object getDefault(String key) {
                if (key.equals("table.name")) {
                    if (JavaEntityContext.this.getEntity().rootEntity().getInheritanceStrategy().isSingleTable()) {
                        IEntity rootEntity = JavaEntityContext.this.getEntity().rootEntity();
                        if (rootEntity == JavaEntityContext.this.getEntity()) {
                            return rootEntity.getName();
                        }
                        return rootEntity.getTable().getName();
                    }
                    return JavaEntityContext.this.getEntity().getName();
                }
                return defaultsContext.getDefault(key);
            }

            public IPersistentType persistentType(String fullyQualifiedTypeName) {
                return defaultsContext.persistentType(fullyQualifiedTypeName);
            }
        };
        if (this.tableContext != null) {
            return this.tableContext.wrapDefaultsContext(wrappedDefaultsContext);
        }
        return wrappedDefaultsContext;
    }

    protected void refreshDefaultAttributeOverrides() {
        Iterator<String> i = this.getEntity().allOverridableAttributeNames();
        while (i.hasNext()) {
            String override = i.next();
            if (this.getEntity().containsAttributeOverride(override)) continue;
            IAttributeOverride attributeOverride = JpaJavaMappingsFactory.eINSTANCE.createJavaAttributeOverride(new IEntity.AttributeOverrideOwner(this.getEntity()), this.getEntity().getType());
            this.getEntity().getDefaultAttributeOverrides().add((Object)attributeOverride);
            ((JavaOverride)((Object)attributeOverride)).setName(override);
        }
        Collection attributeNames = CollectionTools.collection(this.getEntity().allOverridableAttributeNames());
        ArrayList<IAttributeOverride> overridesToRemove = new ArrayList<IAttributeOverride>();
        for (IAttributeOverride attributeOverride : this.getEntity().getDefaultAttributeOverrides()) {
            if (attributeNames.contains(attributeOverride.getName()) && !this.getEntity().containsSpecifiedAttributeOverride(attributeOverride.getName())) continue;
            overridesToRemove.add(attributeOverride);
        }
        this.getEntity().getDefaultAttributeOverrides().removeAll(overridesToRemove);
    }

    protected void refreshDefaultAssociationOverrides() {
        Iterator<String> i = this.getEntity().allOverridableAssociationNames();
        while (i.hasNext()) {
            String override = i.next();
            if (this.getEntity().containsAssociationOverride(override)) continue;
            IAssociationOverride associationOverride = JpaJavaMappingsFactory.eINSTANCE.createJavaAssociationOverride(new IEntity.AssociationOverrideOwner(this.getEntity()), this.getEntity().getType());
            this.getEntity().getDefaultAssociationOverrides().add((Object)associationOverride);
            ((JavaOverride)((Object)associationOverride)).setName(override);
        }
        Collection attributeNames = CollectionTools.collection(this.getEntity().allOverridableAssociationNames());
        ArrayList<IAssociationOverride> overridesToRemove = new ArrayList<IAssociationOverride>();
        for (IAssociationOverride associationOverride : this.getEntity().getDefaultAssociationOverrides()) {
            if (attributeNames.contains(associationOverride.getName()) && !this.getEntity().containsSpecifiedAssociationOverride(associationOverride.getName())) continue;
            overridesToRemove.add(associationOverride);
        }
        this.getEntity().getDefaultAssociationOverrides().removeAll(overridesToRemove);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addTableMessages(messages);
        this.addIdMessages(messages);
        for (SecondaryTableContext secondaryTableContext : this.secondaryTableContexts) {
            secondaryTableContext.addToMessages(messages);
        }
        for (AttributeOverrideContext attributeOverrideContext : this.attributeOverrideContexts) {
            attributeOverrideContext.addToMessages(messages);
        }
        for (AssociationOverrideContext associationOverrideContext : this.associationOverrideContexts) {
            associationOverrideContext.addToMessages(messages);
        }
    }

    protected void addTableMessages(List<IMessage> messages) {
        ITable table = this.getEntity().getTable();
        boolean doContinue = table.isConnected();
        String schema = table.getSchema();
        if (doContinue && !table.hasResolvedSchema()) {
            messages.add(JpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_SCHEMA", new String[]{schema, table.getName()}, table, table.schemaTextRange()));
            doContinue = false;
        }
        if (doContinue && !table.isResolved()) {
            messages.add(JpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_NAME", new String[]{table.getName()}, table, table.nameTextRange()));
        }
    }

    protected void addIdMessages(List<IMessage> messages) {
        this.addNoIdMessage(messages);
    }

    protected void addNoIdMessage(List<IMessage> messages) {
        JavaEntity entity = this.getEntity();
        if (this.entityHasNoId()) {
            messages.add(JpaValidationMessages.buildMessage(1, "ENTITY_NO_ID", new String[]{entity.getName()}, entity, entity.validationTextRange()));
        }
    }

    private boolean entityHasNoId() {
        return !this.entityHasId();
    }

    private boolean entityHasId() {
        Iterator<IPersistentAttribute> stream = this.getEntity().getPersistentType().allAttributes();
        while (stream.hasNext()) {
            if (!stream.next().isIdAttribute()) continue;
            return true;
        }
        return false;
    }
}

