/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaId;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.mappings.IGeneratedValue;
import org.eclipse.jpt.core.internal.mappings.IGenerator;
import org.eclipse.jpt.core.internal.mappings.ISequenceGenerator;
import org.eclipse.jpt.core.internal.mappings.ITableGenerator;
import org.eclipse.jpt.core.internal.platform.ColumnContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.GeneratorRepository;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.IGeneratorRepository;
import org.eclipse.jpt.core.internal.platform.JavaAttributeContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaIdContext
extends JavaAttributeContext {
    private ColumnContext columnContext;

    public JavaIdContext(IContext parentContext, JavaId javaId) {
        super(parentContext, javaId);
        this.columnContext = new ColumnContext(this, javaId.getColumn());
    }

    protected JavaId getId() {
        return (JavaId)this.attributeMapping;
    }

    @Override
    protected void populateGeneratorRepository(GeneratorRepository generatorRepository) {
        ISequenceGenerator sequenceGenerator;
        ITableGenerator tableGenerator = this.getId().getTableGenerator();
        if (tableGenerator != null) {
            generatorRepository.addGenerator(tableGenerator);
        }
        if ((sequenceGenerator = this.getId().getSequenceGenerator()) != null) {
            generatorRepository.addGenerator(sequenceGenerator);
        }
    }

    @Override
    public void refreshDefaultsInternal(DefaultsContext defaultsContext) {
        super.refreshDefaultsInternal(defaultsContext);
        this.columnContext.refreshDefaults(defaultsContext);
        ITableGenerator tableGenerator = this.getId().getTableGenerator();
        if (tableGenerator != null) {
            tableGenerator.refreshDefaults(defaultsContext);
        }
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addColumnMessages(messages);
        this.addGeneratorMessages(messages);
    }

    protected void addColumnMessages(List<IMessage> messages) {
        boolean doContinue;
        JavaId id = this.getId();
        ITypeMapping typeMapping = id.typeMapping();
        IColumn column = id.getColumn();
        String table = column.getTable();
        boolean bl = doContinue = this.entityOwned() && column.isConnected();
        if (doContinue && typeMapping.tableNameIsInvalid(table)) {
            messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.tableTextRange()));
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.nameTextRange()));
        }
    }

    protected void addGeneratorMessages(List<IMessage> messages) {
        JavaId id = this.getId();
        IGeneratedValue generatedValue = id.getGeneratedValue();
        if (generatedValue == null) {
            return;
        }
        String generatorName = generatedValue.getGenerator();
        if (generatorName == null) {
            return;
        }
        IGeneratorRepository generatorRepository = this.persistenceUnitContext().getGeneratorRepository();
        IGenerator generator = generatorRepository.generator(generatorName);
        if (generator == null) {
            messages.add(JpaValidationMessages.buildMessage(1, "GENERATED_VALUE_UNRESOLVED_GENERATOR", new String[]{generatorName}, generatedValue, generatedValue.generatorTextRange()));
        }
    }
}

