/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.core.internal.AccessType;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.IMappingKeys;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.java.IJavaTypeMapping;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.content.java.JpaCompilationUnit;
import org.eclipse.jpt.core.internal.content.orm.PersistenceUnitDefaults;
import org.eclipse.jpt.core.internal.content.orm.PersistenceUnitMetadata;
import org.eclipse.jpt.core.internal.content.orm.XmlRootContentNode;
import org.eclipse.jpt.core.internal.content.persistence.JavaClassRef;
import org.eclipse.jpt.core.internal.content.persistence.MappingFileRef;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.GeneratorRepository;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.IGeneratorRepository;
import org.eclipse.jpt.core.internal.platform.JavaTypeContext;
import org.eclipse.jpt.core.internal.platform.MappingFileContext;
import org.eclipse.jpt.core.internal.platform.TypeContext;
import org.eclipse.jpt.core.internal.platform.XmlTypeContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitContext
extends BaseContext {
    private PersistenceUnit persistenceUnit;
    private List<PersistenceUnitMetadata> persistenceUnitMetadatas;
    private List<MappingFileContext> mappingFileContexts;
    private List<JavaTypeContext> javaPersistentTypeContexts;
    private IGeneratorRepository generatorRepository;
    private Collection<JavaTypeContext> duplicateJavaPersistentTypes;

    public PersistenceUnitContext(IContext parentContext, PersistenceUnit persistenceUnit) {
        super(parentContext);
        this.persistenceUnit = persistenceUnit;
        this.persistenceUnitMetadatas = this.buildPersistenceUnitMetadatas();
        this.duplicateJavaPersistentTypes = new ArrayList<JavaTypeContext>();
        this.mappingFileContexts = this.buildMappingFileContexts();
        this.javaPersistentTypeContexts = this.buildJavaClassesContexts();
        this.generatorRepository = this.buildGeneratorRepository();
    }

    @Override
    protected void initialize() {
    }

    private List<PersistenceUnitMetadata> buildPersistenceUnitMetadatas() {
        ArrayList<PersistenceUnitMetadata> metadatas = new ArrayList<PersistenceUnitMetadata>();
        for (MappingFileRef mappingFileRef : this.persistenceUnit.getMappingFiles()) {
            XmlRootContentNode content = this.xmlRootContentNodeFor(mappingFileRef);
            if (content == null || content.getEntityMappings() == null || content.getEntityMappings().getPersistenceUnitMetadata().isAllFeaturesUnset()) continue;
            metadatas.add(content.getEntityMappings().getPersistenceUnitMetadata());
        }
        return metadatas;
    }

    protected List<MappingFileContext> buildMappingFileContexts() {
        ArrayList<MappingFileContext> contexts = new ArrayList<MappingFileContext>();
        for (MappingFileRef mappingFileRef : this.persistenceUnit.getMappingFiles()) {
            XmlRootContentNode xmlRootContentNode = this.xmlRootContentNodeFor(mappingFileRef);
            if (xmlRootContentNode == null || xmlRootContentNode.getEntityMappings() == null) continue;
            contexts.add(new MappingFileContext(this, xmlRootContentNode));
        }
        return contexts;
    }

    private XmlRootContentNode xmlRootContentNodeFor(MappingFileRef mappingFileRef) {
        IJpaFile jpaFile = mappingFileRef.getMappingFile();
        if (jpaFile != null) {
            try {
                return (XmlRootContentNode)jpaFile.getContent();
            }
            catch (ClassCastException classCastException) {}
        }
        return null;
    }

    protected List<JavaTypeContext> buildJavaClassesContexts() {
        ArrayList<JavaTypeContext> javaPersistentTypeContexts = new ArrayList<JavaTypeContext>();
        for (JavaPersistentType jpType : this.allIncludedJavaPersistentTypes()) {
            if (this.xmlTypeMappingContextFor(jpType.getMapping()) != null) continue;
            JavaTypeContext javaTypeContext = (JavaTypeContext)this.getPlatform().buildJavaTypeContext(this, jpType.getMapping());
            javaPersistentTypeContexts.add(javaTypeContext);
        }
        return javaPersistentTypeContexts;
    }

    protected List<JavaPersistentType> allIncludedJavaPersistentTypes() {
        ArrayList<JavaPersistentType> jpTypes = new ArrayList<JavaPersistentType>();
        Iterator<JavaPersistentType> stream = this.listedJavaPersistentTypes();
        while (stream.hasNext()) {
            JavaPersistentType listedJpType = stream.next();
            if (listedJpType == null || jpTypes.contains(listedJpType)) continue;
            jpTypes.add(listedJpType);
        }
        stream = this.discoveredJavaPersistentTypes();
        while (stream.hasNext()) {
            JavaPersistentType discoveredJpType = stream.next();
            if (discoveredJpType == null || discoveredJpType.getMappingKey() == IMappingKeys.NULL_TYPE_MAPPING_KEY || jpTypes.contains(discoveredJpType)) continue;
            jpTypes.add(discoveredJpType);
        }
        return jpTypes;
    }

    protected Iterator<JavaPersistentType> listedJavaPersistentTypes() {
        return new TransformationIterator<JavaClassRef, JavaPersistentType>(this.persistenceUnit.getClasses().iterator()){

            protected JavaPersistentType transform(JavaClassRef next) {
                return PersistenceUnitContext.this.javaPersistentTypeFor(next);
            }
        };
    }

    protected Iterator<JavaPersistentType> discoveredJavaPersistentTypes() {
        if (!this.persistenceUnit.getJpaProject().isDiscoverAnnotatedClasses()) {
            return EmptyIterator.instance();
        }
        Collection<IJpaFile> javaJpaFiles = this.persistenceUnit.getJpaProject().jpaFiles("org.eclipse.jdt.core.javaSource");
        return new CompositeIterator((Iterator)new TransformationIterator<IJpaFile, Iterator<JavaPersistentType>>(javaJpaFiles.iterator()){

            protected Iterator<JavaPersistentType> transform(IJpaFile next) {
                JpaCompilationUnit jcu = (JpaCompilationUnit)next.getContent();
                return jcu.getTypes().iterator();
            }
        });
    }

    protected IGeneratorRepository buildGeneratorRepository() {
        GeneratorRepository generatorRepository = new GeneratorRepository();
        for (JavaTypeContext javaTypeContext : this.javaPersistentTypeContexts) {
            javaTypeContext.populateGeneratorRepository(generatorRepository);
        }
        for (MappingFileContext mappingFileContext : this.mappingFileContexts) {
            mappingFileContext.populateGeneratorRepository(generatorRepository);
        }
        return generatorRepository;
    }

    private JavaPersistentType javaPersistentTypeFor(JavaClassRef javaClassRef) {
        IType type = javaClassRef.findJdtType();
        return this.jpaProject().findJavaPersistentType(type);
    }

    public XmlTypeContext xmlTypeMappingContextFor(IJavaTypeMapping javaTypeMapping) {
        for (MappingFileContext context : this.mappingFileContexts) {
            XmlTypeContext xmlTypeMappingContext = context.xmlTypeMappingContextFor(javaTypeMapping);
            if (xmlTypeMappingContext == null) continue;
            return xmlTypeMappingContext;
        }
        return null;
    }

    protected IJpaProject jpaProject() {
        return this.persistenceUnit.getJpaProject();
    }

    PersistenceUnit persistenceUnit() {
        return this.persistenceUnit;
    }

    Iterator<IPersistentType> persistentTypes() {
        return new CompositeIterator(new Iterator[]{new CompositeIterator((Iterator)new TransformationIterator<MappingFileContext, Iterator<IPersistentType>>(this.mappingFileContexts.iterator()){

            protected Iterator<IPersistentType> transform(MappingFileContext next) {
                return next.persistentTypes();
            }
        }), new TransformationIterator<JavaTypeContext, IPersistentType>(this.javaPersistentTypeContexts.iterator()){

            protected IPersistentType transform(JavaTypeContext next) {
                return next.getPersistentType();
            }
        }});
    }

    @Override
    public void refreshDefaults(DefaultsContext parentDefaults) {
        super.refreshDefaults(parentDefaults);
        for (JavaTypeContext context : this.duplicateJavaPersistentTypes) {
            context.refreshDefaults(parentDefaults);
        }
        DefaultsContext defaults = this.wrapDefaultsContext(parentDefaults);
        for (MappingFileContext mappingFileContext : this.mappingFileContexts) {
            mappingFileContext.refreshDefaults(defaults);
        }
        for (JavaTypeContext javaTypeContext : this.javaPersistentTypeContexts) {
            javaTypeContext.refreshDefaults(defaults);
        }
    }

    protected DefaultsContext wrapDefaultsContext(DefaultsContext defaults) {
        final DefaultsContext puDefaults = this.buildPersistenceUnitDefaults(defaults);
        return new DefaultsContext(){

            public Object getDefault(String key) {
                return puDefaults.getDefault(key);
            }

            public IPersistentType persistentType(String fullyQualifiedTypeName) {
                Iterator i = PersistenceUnitContext.this.typeContexts();
                while (i.hasNext()) {
                    TypeContext typeContext = (TypeContext)i.next();
                    IPersistentType persistentType = typeContext.getPersistentType();
                    IType jdtType = persistentType.findJdtType();
                    if (jdtType == null || !fullyQualifiedTypeName.equals(jdtType.getFullyQualifiedName())) continue;
                    if (!typeContext.isRefreshed()) {
                        typeContext.refreshDefaults(this);
                    }
                    return persistentType;
                }
                return null;
            }
        };
    }

    protected DefaultsContext buildPersistenceUnitDefaults(final DefaultsContext defaults) {
        if (this.persistenceUnitMetadatas.size() == 1) {
            final PersistenceUnitDefaults puDefaults = this.persistenceUnitMetadatas.get(0).getPersistenceUnitDefaults();
            if (puDefaults.isAllFeaturesUnset()) {
                return defaults;
            }
            return new DefaultsContext(){

                public Object getDefault(String key) {
                    AccessType access;
                    String catalog;
                    String schema;
                    if ((key.equals("table.schema") || key.equals("tableGenerator.schema")) && (schema = puDefaults.getSchema()) != null) {
                        return schema;
                    }
                    if (key.equals("table.catalog") && (catalog = puDefaults.getCatalog()) != null) {
                        return catalog;
                    }
                    if (key.equals("access") && (access = puDefaults.getAccess()) != null) {
                        return access;
                    }
                    return defaults.getDefault(key);
                }

                public IPersistentType persistentType(String fullyQualifiedTypeName) {
                    return defaults.persistentType(fullyQualifiedTypeName);
                }
            };
        }
        return defaults;
    }

    private Iterator<TypeContext> typeContexts() {
        return new CompositeIterator(new Iterator[]{this.mappingFileTypeContexts(), this.javaTypeContexts()});
    }

    private Iterator mappingFileTypeContexts() {
        return new CompositeIterator((Iterator)new TransformationIterator(this.mappingFileContexts.iterator()){

            protected Object transform(Object next) {
                return ((MappingFileContext)next).typeContexts();
            }
        });
    }

    private Iterator javaTypeContexts() {
        return this.javaPersistentTypeContexts.iterator();
    }

    public void addDuplicateJpaFile(JavaTypeContext javaPersistentTypeContext) {
        this.duplicateJavaPersistentTypes.add(javaPersistentTypeContext);
    }

    public boolean containsDuplicateJavaPersistentType(JavaPersistentType javaPersistentType) {
        for (JavaTypeContext context : this.duplicateJavaPersistentTypes) {
            if (context.getPersistentType() != javaPersistentType) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IPersistentType persistentType) {
        for (MappingFileContext mappingFileContext : this.mappingFileContexts) {
            if (!mappingFileContext.contains(persistentType)) continue;
            return true;
        }
        for (JavaTypeContext javaTypeContext : this.javaPersistentTypeContexts) {
            if (!javaTypeContext.contains(persistentType)) continue;
            return true;
        }
        return false;
    }

    public IGeneratorRepository getGeneratorRepository() {
        return this.generatorRepository;
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addMappingFileMessages(messages);
        this.addClassMessages(messages);
    }

    protected void addMappingFileMessages(List<IMessage> messages) {
        this.addMultipleMetadataMessages(messages);
        this.addUnspecifiedMappingFileMessages(messages);
        this.addUnresolvedMappingFileMessages(messages);
        this.addInvalidMappingFileContentMessage(messages);
        this.addDuplicateMappingFileMessages(messages);
        for (MappingFileContext mappingFileContext : this.mappingFileContexts) {
            mappingFileContext.addToMessages(messages);
        }
    }

    protected void addMultipleMetadataMessages(List<IMessage> messages) {
        if (this.persistenceUnitMetadatas.size() > 1) {
            for (PersistenceUnitMetadata metadata : this.persistenceUnitMetadatas) {
                messages.add(JpaValidationMessages.buildMessage(1, "ENTITY_MAPPINGS_MULTIPLE_METADATA", new String[]{this.persistenceUnit.getName()}, metadata, metadata.validationTextRange()));
            }
        }
    }

    protected void addUnspecifiedMappingFileMessages(List<IMessage> messages) {
        for (MappingFileRef mappingFileRef : this.persistenceUnit.getMappingFiles()) {
            if (mappingFileRef.getFileName() != null && !mappingFileRef.getFileName().equals("")) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_MAPPING_FILE", mappingFileRef, mappingFileRef.validationTextRange()));
        }
    }

    protected void addUnresolvedMappingFileMessages(List<IMessage> messages) {
        for (MappingFileRef mappingFileRef : this.persistenceUnit.getMappingFiles()) {
            if (mappingFileRef.getFileName() == null || mappingFileRef.getFileName().equals("") || mappingFileRef.getMappingFile() != null) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_NONEXISTENT_MAPPING_FILE", new String[]{mappingFileRef.getFileName()}, mappingFileRef, mappingFileRef.validationTextRange()));
        }
    }

    protected void addInvalidMappingFileContentMessage(List<IMessage> messages) {
        for (MappingFileRef mappingFileRef : this.persistenceUnit.getMappingFiles()) {
            if (mappingFileRef.getMappingFile() == null || this.xmlRootContentNodeFor(mappingFileRef) != null) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_INVALID_MAPPING_FILE", new String[]{mappingFileRef.getFileName()}, mappingFileRef, mappingFileRef.validationTextRange()));
        }
    }

    protected void addDuplicateMappingFileMessages(List<IMessage> messages) {
        HashBag fileBag = new HashBag(CollectionTools.collection((Iterator)new TransformationIterator(this.persistenceUnit.getMappingFiles().iterator()){

            protected Object transform(Object next) {
                return ((MappingFileRef)next).getFileName();
            }
        }));
        for (MappingFileRef mappingFileRef : this.persistenceUnit.getMappingFiles()) {
            if (fileBag.count((Object)mappingFileRef.getFileName()) <= 1) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_MAPPING_FILE", new String[]{mappingFileRef.getFileName()}, mappingFileRef, mappingFileRef.validationTextRange()));
        }
    }

    protected void addClassMessages(List<IMessage> messages) {
        this.addUnspecifiedClassMessages(messages);
        this.addUnresolvedClassMessages(messages);
        this.addInvalidClassContentMessages(messages);
        this.addDuplicateClassMessages(messages);
        for (JavaTypeContext persistentTypeContext : this.javaPersistentTypeContexts) {
            persistentTypeContext.addToMessages(messages);
        }
    }

    protected void addUnspecifiedClassMessages(List<IMessage> messages) {
        for (JavaClassRef javaClassRef : this.persistenceUnit.getClasses()) {
            String javaClass = javaClassRef.getJavaClass();
            if (!StringTools.stringIsEmpty((String)javaClass)) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_CLASS", javaClassRef, javaClassRef.validationTextRange()));
        }
    }

    protected void addUnresolvedClassMessages(List<IMessage> messages) {
        for (JavaClassRef javaClassRef : this.persistenceUnit.getClasses()) {
            String javaClass = javaClassRef.getJavaClass();
            if (StringTools.stringIsEmpty((String)javaClass) || javaClassRef.findJdtType() != null) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_NONEXISTENT_CLASS", new String[]{javaClass}, javaClassRef, javaClassRef.validationTextRange()));
        }
    }

    protected void addInvalidClassContentMessages(List<IMessage> messages) {
        for (JavaClassRef javaClassRef : this.persistenceUnit.getClasses()) {
            String javaClass = javaClassRef.getJavaClass();
            if (StringTools.stringIsEmpty((String)javaClass) || javaClassRef.findJdtType() == null || this.javaPersistentTypeFor(javaClassRef) != null && this.javaPersistentTypeFor(javaClassRef).getMappingKey() != IMappingKeys.NULL_TYPE_MAPPING_KEY) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_INVALID_CLASS", new String[]{javaClassRef.getJavaClass()}, javaClassRef, javaClassRef.validationTextRange()));
        }
    }

    protected void addDuplicateClassMessages(List<IMessage> messages) {
        HashBag fileBag = new HashBag(CollectionTools.collection((Iterator)new TransformationIterator(this.persistenceUnit.getClasses().iterator()){

            protected Object transform(Object next) {
                return ((JavaClassRef)next).getJavaClass();
            }
        }));
        for (JavaClassRef javaClassRef : this.persistenceUnit.getClasses()) {
            if (javaClassRef.getJavaClass() == null || fileBag.count((Object)javaClassRef.getJavaClass()) <= 1) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_CLASS", new String[]{javaClassRef.getJavaClass()}, javaClassRef, javaClassRef.validationTextRange()));
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.persistenceUnit.getName());
    }
}

