/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.mappings.IPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.mappings.ISecondaryTable;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.PrimaryKeyJoinColumnContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondaryTableContext
extends BaseContext {
    private ISecondaryTable secondaryTable;
    private Collection<PrimaryKeyJoinColumnContext> pkJoinColumnContexts;

    public SecondaryTableContext(IContext parentContext, ISecondaryTable secondaryTable) {
        super(parentContext);
        this.secondaryTable = secondaryTable;
        this.pkJoinColumnContexts = this.buildPkJoinColumnContexts();
    }

    protected Collection<PrimaryKeyJoinColumnContext> buildPkJoinColumnContexts() {
        ArrayList<PrimaryKeyJoinColumnContext> contexts = new ArrayList<PrimaryKeyJoinColumnContext>();
        for (IPrimaryKeyJoinColumn pkJoinColumn : this.getSecondaryTable().getPrimaryKeyJoinColumns()) {
            contexts.add(new PrimaryKeyJoinColumnContext((IContext)this, pkJoinColumn));
        }
        return contexts;
    }

    @Override
    protected void initialize() {
    }

    public ISecondaryTable getSecondaryTable() {
        return this.secondaryTable;
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        this.secondaryTable.refreshDefaults(defaultsContext);
        for (PrimaryKeyJoinColumnContext context : this.pkJoinColumnContexts) {
            context.refreshDefaults(defaultsContext);
        }
    }

    public DefaultsContext wrapDefaultsContext(final DefaultsContext defaultsContext) {
        return new DefaultsContext(){

            public Object getDefault(String key) {
                return defaultsContext.getDefault(key);
            }

            public IPersistentType persistentType(String fullyQualifiedTypeName) {
                return defaultsContext.persistentType(fullyQualifiedTypeName);
            }
        };
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addTableMessages(messages);
        for (PrimaryKeyJoinColumnContext context : this.pkJoinColumnContexts) {
            context.addToMessages(messages);
        }
    }

    protected void addTableMessages(List<IMessage> messages) {
        boolean doContinue = this.secondaryTable.isConnected();
        String schema = this.secondaryTable.getSchema();
        if (doContinue && !this.secondaryTable.hasResolvedSchema()) {
            messages.add(JpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.secondaryTable.getName()}, this.secondaryTable, this.secondaryTable.schemaTextRange()));
            doContinue = false;
        }
        if (doContinue && !this.secondaryTable.isResolved()) {
            messages.add(JpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_NAME", new String[]{this.secondaryTable.getName()}, this.secondaryTable, this.secondaryTable.nameTextRange()));
        }
    }
}

