/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaId;
import org.eclipse.jpt.core.internal.content.orm.XmlId;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.mappings.IGeneratedValue;
import org.eclipse.jpt.core.internal.mappings.IGenerator;
import org.eclipse.jpt.core.internal.mappings.ISequenceGenerator;
import org.eclipse.jpt.core.internal.mappings.ITableGenerator;
import org.eclipse.jpt.core.internal.platform.ColumnContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.GeneratorRepository;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.IGeneratorRepository;
import org.eclipse.jpt.core.internal.platform.MappingFileContext;
import org.eclipse.jpt.core.internal.platform.PersistenceUnitContext;
import org.eclipse.jpt.core.internal.platform.XmlAttributeContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlIdContext
extends XmlAttributeContext {
    private ColumnContext columnContext;

    public XmlIdContext(IContext parentContext, XmlId xmlId) {
        super(parentContext, xmlId);
        this.columnContext = new ColumnContext(this, xmlId.getColumn());
        this.populateGeneratorRepository((GeneratorRepository)this.getPersistenceUnitContext().getGeneratorRepository());
    }

    protected PersistenceUnitContext getPersistenceUnitContext() {
        return ((MappingFileContext)this.getParentContext().getParentContext()).getPersistenceUnitContext();
    }

    protected void populateGeneratorRepository(GeneratorRepository generatorRepository) {
        ISequenceGenerator sequenceGenerator;
        ITableGenerator tableGenerator = this.getId().getTableGenerator();
        if (tableGenerator != null) {
            generatorRepository.addGenerator(tableGenerator);
        }
        if ((sequenceGenerator = this.getId().getSequenceGenerator()) != null) {
            generatorRepository.addGenerator(sequenceGenerator);
        }
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        this.columnContext.refreshDefaults(defaultsContext);
        ITableGenerator tableGenerator = this.getId().getTableGenerator();
        if (tableGenerator != null) {
            tableGenerator.refreshDefaults(defaultsContext);
        }
    }

    @Override
    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        if (key.equals("column.name")) {
            if (this.attributeMapping().getPersistentAttribute().isVirtual() && this.javaIdMapping() != null) {
                if (!this.attributeMapping().getPersistentType().getMapping().isXmlMetadataComplete()) {
                    return this.javaIdMapping().getColumn().getName();
                }
                return this.javaIdMapping().getColumn().getDefaultName();
            }
            return this.attributeMapping().getPersistentAttribute().getName();
        }
        return super.getDefault(key, defaultsContext);
    }

    protected JavaId javaIdMapping() {
        IAttributeMapping attributeMapping = this.javaAttributeMapping();
        if (attributeMapping.getKey() == "id") {
            return (JavaId)attributeMapping;
        }
        return null;
    }

    protected XmlId getId() {
        return (XmlId)this.attributeMapping();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.entityOwned()) {
            this.addColumnMessages(messages);
        }
        this.addGeneratorMessages(messages);
    }

    protected void addColumnMessages(List<IMessage> messages) {
        XmlId id = this.getId();
        XmlTypeMapping typeMapping = id.typeMapping();
        IColumn column = id.getColumn();
        String table = column.getTable();
        boolean doContinue = column.isConnected();
        if (doContinue && typeMapping.tableNameIsInvalid(table)) {
            if (id.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_TABLE", new String[]{id.getPersistentAttribute().getName(), table, column.getName()}, column, column.tableTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.tableTextRange()));
            }
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            if (id.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{id.getPersistentAttribute().getName(), column.getName()}, column, column.nameTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.nameTextRange()));
            }
        }
    }

    protected void addGeneratorMessages(List<IMessage> messages) {
        XmlId id = this.getId();
        IGeneratedValue generatedValue = id.getGeneratedValue();
        if (generatedValue == null) {
            return;
        }
        String generatorName = generatedValue.getGenerator();
        if (generatorName == null) {
            return;
        }
        IGeneratorRepository generatorRepository = this.getPersistenceUnitContext().getGeneratorRepository();
        IGenerator generator = generatorRepository.generator(generatorName);
        if (generator == null) {
            messages.add(JpaValidationMessages.buildMessage(1, "GENERATED_VALUE_UNRESOLVED_GENERATOR", new String[]{generatorName}, generatedValue, generatedValue.validationTextRange()));
        }
    }
}

