/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;

public class XMLSourcePreferencePage
extends AbstractPreferencePage
implements ModifyListener,
SelectionListener,
IWorkbenchPreferencePage {
    private final int MIN_INDENTATION_SIZE = 0;
    private final int MAX_INDENTATION_SIZE = 16;
    protected Button fAutoPropose;
    protected Label fAutoProposeLabel;
    protected Text fAutoProposeText;
    private Combo fSuggestionStrategyCombo;
    private Vector fSuggestionStrategies = null;
    protected Button fClearAllBlankLines;
    protected Label fLineWidthLabel;
    protected Text fLineWidthText;
    protected Button fSplitMultiAttrs;
    private Button fIndentUsingTabs;
    private Button fIndentUsingSpaces;
    private Spinner fIndentationSize;
    private Button fPreservePCDATAContent;
    private Button fAlignEndBracket;
    protected Button fUseInferredGrammar;

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.xml.ui.webx0061");
        this.createContentsForFormattingGroup(composite);
        this.createContentsForContentAssistGroup(composite);
        this.createContentsForGrammarConstraintsGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void createContentsForContentAssistGroup(Composite parent) {
        Group contentAssistGroup = this.createGroup(parent, 2);
        contentAssistGroup.setText(XMLUIMessages.Content_assist_UI_);
        this.fAutoPropose = this.createCheckBox((Composite)contentAssistGroup, XMLUIMessages.Automatically_make_suggest_UI_);
        ((GridData)this.fAutoPropose.getLayoutData()).horizontalSpan = 2;
        this.fAutoPropose.addSelectionListener((SelectionListener)this);
        this.fAutoProposeLabel = this.createLabel((Composite)contentAssistGroup, XMLUIMessages.Prompt_when_these_characte_UI_);
        this.fAutoProposeText = this.createTextField((Composite)contentAssistGroup);
        this.createLabel((Composite)contentAssistGroup, XMLUIMessages.Suggestion_Strategy);
        this.fSuggestionStrategyCombo = new Combo((Composite)contentAssistGroup, 8);
        this.fSuggestionStrategies = new Vector();
        this.fSuggestionStrategyCombo.setLayoutData((Object)new GridData(768));
        this.fSuggestionStrategyCombo.add(XMLUIMessages.Suggestion_Strategy_Lax);
        this.fSuggestionStrategies.add("Lax");
        this.fSuggestionStrategyCombo.add(XMLUIMessages.Suggestion_Strategy_Strict);
        this.fSuggestionStrategies.add("Strict");
    }

    protected void createContentsForFormattingGroup(Composite parent) {
        Group formattingGroup = this.createGroup(parent, 2);
        formattingGroup.setText(XMLUIMessages.Formatting_UI_);
        this.fLineWidthLabel = this.createLabel((Composite)formattingGroup, XMLUIMessages.Line_width__UI_);
        this.fLineWidthText = new Text((Composite)formattingGroup, 2052);
        GridData gData = new GridData(33);
        gData.widthHint = 25;
        this.fLineWidthText.setLayoutData((Object)gData);
        this.fLineWidthText.addModifyListener((ModifyListener)this);
        this.fSplitMultiAttrs = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Split_multiple_attributes);
        ((GridData)this.fSplitMultiAttrs.getLayoutData()).horizontalSpan = 2;
        this.fAlignEndBracket = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Align_final_bracket);
        ((GridData)this.fAlignEndBracket.getLayoutData()).horizontalSpan = 2;
        this.fPreservePCDATAContent = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Preserve_PCDATA_Content);
        ((GridData)this.fPreservePCDATAContent.getLayoutData()).horizontalSpan = 2;
        this.fClearAllBlankLines = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Clear_all_blank_lines_UI_);
        ((GridData)this.fClearAllBlankLines.getLayoutData()).horizontalSpan = 2;
        this.fIndentUsingTabs = this.createRadioButton((Composite)formattingGroup, XMLUIMessages.Indent_using_tabs);
        ((GridData)this.fIndentUsingTabs.getLayoutData()).horizontalSpan = 2;
        this.fIndentUsingSpaces = this.createRadioButton((Composite)formattingGroup, XMLUIMessages.Indent_using_spaces);
        ((GridData)this.fIndentUsingSpaces.getLayoutData()).horizontalSpan = 2;
        this.createLabel((Composite)formattingGroup, XMLUIMessages.Indentation_size);
        this.fIndentationSize = new Spinner((Composite)formattingGroup, 2056);
        GridData gd = new GridData(32);
        this.fIndentationSize.setLayoutData((Object)gd);
        this.fIndentationSize.setToolTipText(XMLUIMessages.Indentation_size_tip);
        this.fIndentationSize.setMinimum(0);
        this.fIndentationSize.setMaximum(16);
        this.fIndentationSize.setIncrement(1);
        this.fIndentationSize.setPageIncrement(4);
        this.fIndentationSize.addModifyListener((ModifyListener)this);
    }

    protected void createContentsForGrammarConstraintsGroup(Composite parent) {
        Group grammarConstraintsGroup = this.createGroup(parent, 1);
        grammarConstraintsGroup.setText(XMLUIMessages.Grammar_Constraints);
        grammarConstraintsGroup.setLayoutData((Object)new GridData(768));
        this.fUseInferredGrammar = this.createCheckBox((Composite)grammarConstraintsGroup, XMLUIMessages.Use_inferred_grammar_in_absence_of);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    protected void doSavePreferenceStore() {
        XMLUIPlugin.getDefault().savePluginPreferences();
        XMLCorePlugin.getDefault().savePluginPreferences();
    }

    protected void enableValues() {
        if (this.fAutoPropose != null) {
            if (this.fAutoPropose.getSelection()) {
                this.fAutoProposeLabel.setEnabled(true);
                this.fAutoProposeText.setEnabled(true);
            } else {
                this.fAutoProposeLabel.setEnabled(false);
                this.fAutoProposeText.setEnabled(false);
            }
        }
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    private String getCurrentSuggestionStrategy() {
        int i = this.fSuggestionStrategyCombo.getSelectionIndex();
        if (i >= 0) {
            return (String)this.fSuggestionStrategies.elementAt(i);
        }
        return "";
    }

    protected void initializeValues() {
        this.initializeValuesForFormattingGroup();
        this.initializeValuesForContentAssistGroup();
        this.initializeValuesForGrammarConstraintsGroup();
    }

    protected void initializeValuesForContentAssistGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getBoolean(XMLUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getString(XMLUIPreferenceNames.AUTO_PROPOSE_CODE));
        String suggestionStrategy = this.getPreferenceStore().getString(XMLUIPreferenceNames.SUGGESTION_STRATEGY);
        if (suggestionStrategy.length() > 0) {
            this.setCurrentSuggestionStrategy(suggestionStrategy);
        } else {
            this.setCurrentSuggestionStrategy("Lax");
        }
    }

    protected void initializeValuesForFormattingGroup() {
        this.fLineWidthText.setText(this.getModelPreferences().getString("lineWidth"));
        this.fSplitMultiAttrs.setSelection(this.getModelPreferences().getBoolean("splitMultiAttrs"));
        this.fAlignEndBracket.setSelection(this.getModelPreferences().getBoolean("alignEndBracket"));
        this.fClearAllBlankLines.setSelection(this.getModelPreferences().getBoolean("clearAllBlankLines"));
        this.fPreservePCDATAContent.setSelection(this.getModelPreferences().getBoolean("preserveCDATAContent"));
        if ("tab".equals(this.getModelPreferences().getString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getInt("indentationSize"));
    }

    protected void initializeValuesForGrammarConstraintsGroup() {
        this.fUseInferredGrammar.setSelection(this.getPreferenceStore().getBoolean(XMLUIPreferenceNames.USE_INFERRED_GRAMMAR));
    }

    protected void performDefaults() {
        this.performDefaultsForFormattingGroup();
        this.performDefaultsForContentAssistGroup();
        this.performDefaultsForGrammarConstraintsGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    protected void performDefaultsForContentAssistGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getDefaultBoolean(XMLUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getDefaultString(XMLUIPreferenceNames.AUTO_PROPOSE_CODE));
        String suggestionStrategy = this.getPreferenceStore().getDefaultString(XMLUIPreferenceNames.SUGGESTION_STRATEGY);
        if (suggestionStrategy.length() > 0) {
            this.setCurrentSuggestionStrategy(suggestionStrategy);
        } else {
            this.setCurrentSuggestionStrategy("Lax");
        }
    }

    protected void performDefaultsForFormattingGroup() {
        this.fLineWidthText.setText(this.getModelPreferences().getDefaultString("lineWidth"));
        this.fSplitMultiAttrs.setSelection(this.getModelPreferences().getDefaultBoolean("splitMultiAttrs"));
        this.fAlignEndBracket.setSelection(this.getModelPreferences().getDefaultBoolean("alignEndBracket"));
        this.fClearAllBlankLines.setSelection(this.getModelPreferences().getDefaultBoolean("clearAllBlankLines"));
        this.fPreservePCDATAContent.setSelection(this.getModelPreferences().getDefaultBoolean("preserveCDATAContent"));
        if ("tab".equals(this.getModelPreferences().getDefaultString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getDefaultInt("indentationSize"));
    }

    protected void performDefaultsForGrammarConstraintsGroup() {
        this.fUseInferredGrammar.setSelection(this.getPreferenceStore().getDefaultBoolean(XMLUIPreferenceNames.USE_INFERRED_GRAMMAR));
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }

    private void setCurrentSuggestionStrategy(String strategy) {
        this.fSuggestionStrategyCombo.clearSelection();
        this.fSuggestionStrategyCombo.deselectAll();
        int i = this.fSuggestionStrategies.indexOf(strategy);
        if (i >= 0) {
            this.fSuggestionStrategyCombo.select(i);
        }
    }

    protected void storeValues() {
        this.storeValuesForFormattingGroup();
        this.storeValuesForContentAssistGroup();
        this.storeValuesForGrammarConstraintsGroup();
    }

    protected void storeValuesForContentAssistGroup() {
        this.getPreferenceStore().setValue(XMLUIPreferenceNames.AUTO_PROPOSE, this.fAutoPropose.getSelection());
        this.getPreferenceStore().setValue(XMLUIPreferenceNames.AUTO_PROPOSE_CODE, this.fAutoProposeText.getText());
        this.getPreferenceStore().setValue(XMLUIPreferenceNames.SUGGESTION_STRATEGY, this.getCurrentSuggestionStrategy());
    }

    protected void storeValuesForFormattingGroup() {
        this.getModelPreferences().setValue("lineWidth", this.fLineWidthText.getText());
        this.getModelPreferences().setValue("splitMultiAttrs", this.fSplitMultiAttrs.getSelection());
        this.getModelPreferences().setValue("alignEndBracket", this.fAlignEndBracket.getSelection());
        this.getModelPreferences().setValue("clearAllBlankLines", this.fClearAllBlankLines.getSelection());
        this.getModelPreferences().setValue("preserveCDATAContent", this.fPreservePCDATAContent.getSelection());
        if (this.fIndentUsingTabs.getSelection()) {
            this.getModelPreferences().setValue("indentationChar", "tab");
        } else {
            this.getModelPreferences().setValue("indentationChar", "space");
        }
        this.getModelPreferences().setValue("indentationSize", this.fIndentationSize.getSelection());
    }

    protected void storeValuesForGrammarConstraintsGroup() {
        this.getPreferenceStore().setValue(XMLUIPreferenceNames.USE_INFERRED_GRAMMAR, this.fUseInferredGrammar.getSelection());
    }

    protected void validateValues() {
        boolean isError = false;
        String widthText = null;
        if (this.fLineWidthText != null) {
            try {
                widthText = this.fLineWidthText.getText();
                int formattingLineWidth = Integer.parseInt(widthText);
                if (formattingLineWidth < 0 || formattingLineWidth > 999) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setInvalidInputMessage(widthText);
                this.setValid(false);
                isError = true;
            }
        }
        int indentSize = 0;
        if (this.fIndentationSize != null) {
            try {
                indentSize = this.fIndentationSize.getSelection();
                if (indentSize < 0 || indentSize > 16) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setInvalidInputMessage(Integer.toString(indentSize));
                this.setValid(false);
                isError = true;
            }
        }
        if (!isError) {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }
}

