/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorCSHelpIds;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.NameSection;
import org.eclipse.wst.wsdl.ui.internal.util.ReferenceEditManagerHelper;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;

public class ParameterSection
extends NameSection {
    protected static String NEW_STRING = Messages._UI_BUTTON_NEW;
    protected static String BROWSE_STRING = Messages._UI_BUTTON_BROWSE;
    protected CLabel comboLabel;
    protected CCombo combo;
    protected boolean handleTypeScenario = true;
    protected ComponentReferenceEditManager parameterRefManager;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.createControlArea();
    }

    public void createControlArea() {
        this.combo = this.getWidgetFactory().createCCombo(this.composite);
        this.combo.setBackground(this.composite.getBackground());
        this.combo.addListener(24, (Listener)this);
        this.combo.addSelectionListener((SelectionListener)this);
        this.comboLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages._UI_LABEL_TYPE) + ":");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.combo, -5);
        data.top = new FormAttachment((Control)this.combo, 0, 0x1000000);
        this.comboLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.nameText, 4);
        this.combo.setLayoutData((Object)data);
    }

    public void refresh() {
        super.refresh();
        if (this.nameText.isFocusControl()) {
            return;
        }
        this.setListenerEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.combo, ASDEditorCSHelpIds.PROPERTIES_PART_ELEMENT_COMBO);
        if (this.handleTypeScenario) {
            this.refreshCombo();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.combo, ASDEditorCSHelpIds.PROPERTIES_PART_TYPE_COMBO);
        }
        this.setControlForegroundColor((Control)this.combo);
        this.setListenerEnabled(true);
    }

    protected void refreshCombo() {
        int index;
        IParameter param = null;
        Object model = this.getModel();
        this.setListenerEnabled(false);
        if (model instanceof IParameter) {
            param = (IParameter)model;
        }
        String name = "";
        String typeName = "";
        if (param != null) {
            name = param.getName();
            typeName = param.getComponentName();
        }
        if (!this.nameText.isFocusControl()) {
            this.nameText.setText(name);
        }
        this.combo.removeAll();
        this.combo.add(BROWSE_STRING);
        this.combo.add(NEW_STRING);
        ComponentReferenceEditManager editManager = this.getComponentReferenceEditManager();
        if (editManager != null) {
            ComponentSpecification[] specs = editManager.getQuickPicks();
            index = 0;
            while (index < specs.length) {
                this.combo.add(specs[index].getName());
                ++index;
            }
            specs = editManager.getHistory();
            index = 0;
            while (index < specs.length) {
                this.combo.add(specs[index].getName());
                ++index;
            }
        }
        String[] items = this.combo.getItems();
        index = 0;
        while (index < items.length) {
            if (items[index].equals(typeName)) break;
            ++index;
        }
        if (index < items.length) {
            this.combo.select(index);
        } else {
            this.combo.setText(typeName);
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.combo) {
            if (this.isListenerEnabled() && !this.isInDoHandle) {
                this.isInDoHandle = true;
                this.startDelayedEvent(event);
                this.isInDoHandle = false;
            }
        } else {
            super.handleEvent(event);
        }
    }

    public void doHandleEvent(Event event) {
        super.doHandleEvent(event);
        if (event.widget == this.combo && this.handleTypeScenario) {
            this.handleComboSelection();
            this.refresh();
        }
    }

    protected void handleComboSelection() {
        String value = this.combo.getItem(this.combo.getSelectionIndex());
        IParameter parameter = (IParameter)this.getModel();
        if (value.equals(NEW_STRING)) {
            Command command = parameter.getSetTypeCommand("SetTypeAction_AddType");
            command.execute();
        } else if (value.equals(BROWSE_STRING)) {
            Command command = parameter.getSetTypeCommand("SetTypeAction_ExistingType");
            command.execute();
        } else {
            ComponentReferenceEditManager editManager = this.getComponentReferenceEditManager();
            ComponentSpecification spec = this.getComponentSpecificationForValue(value);
            if (spec != null) {
                editManager.modifyComponentReference((Object)parameter, spec);
            }
        }
    }

    protected ComponentReferenceEditManager getComponentReferenceEditManager() {
        if (this.parameterRefManager != null) {
            return this.parameterRefManager;
        }
        if (this.getModel() instanceof IASDObject) {
            this.parameterRefManager = ReferenceEditManagerHelper.getXSDTypeReferenceEditManager((IASDObject)this.getModel());
        } else {
            System.out.println("model" + this.getModel());
        }
        return this.parameterRefManager;
    }

    protected ComponentSpecification getComponentSpecificationForValue(String value) {
        ComponentReferenceEditManager editManager = this.getComponentReferenceEditManager();
        if (editManager != null) {
            ComponentSpecification[] history;
            ComponentSpecification[] quickPicks = editManager.getQuickPicks();
            if (quickPicks != null) {
                int i = 0;
                while (i < quickPicks.length) {
                    ComponentSpecification componentSpecification = quickPicks[i];
                    if (value.equals(componentSpecification.getName())) {
                        return componentSpecification;
                    }
                    ++i;
                }
            }
            if ((history = editManager.getHistory()) != null) {
                int i = 0;
                while (i < history.length) {
                    ComponentSpecification componentSpecification = history[i];
                    if (value.equals(componentSpecification.getName())) {
                        return componentSpecification;
                    }
                    ++i;
                }
            }
        }
        return null;
    }
}

