/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeUtil {
    static IType resolveType(IType owningType, String typeSignature) {
        if (typeSignature.charAt(0) == 'L' || Signature.getTypeSignatureKind((String)typeSignature) == 4 && Signature.getElementType((String)typeSignature).charAt(0) == 'L') {
            IType type = null;
            try {
                type = owningType.getJavaProject().findType(TypeUtil.getFullyQualifiedName(typeSignature));
            }
            catch (JavaModelException javaModelException) {}
            return type;
        }
        return TypeUtil.resolveTypeRelative(owningType, typeSignature);
    }

    public static String resolveTypeSignature(IType owningType, String typeSignature) {
        return TypeUtil.resolveTypeSignature(owningType, typeSignature, true);
    }

    public static String resolveTypeSignature(IType owningType, String typeSignature, boolean eraseTypeParameters) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSignature);
        switch (sigKind) {
            case 2: {
                return typeSignature;
            }
            case 4: {
                String elementType = Signature.getElementType((String)typeSignature);
                if (Signature.getTypeSignatureKind((String)elementType) == 2) {
                    return typeSignature;
                }
                String resolvedElementType = TypeUtil.resolveSignatureRelative(owningType, elementType, eraseTypeParameters);
                String resultType = "";
                int i = 0;
                while (i < Signature.getArrayCount((String)typeSignature)) {
                    resultType = String.valueOf(resultType) + '[';
                    ++i;
                }
                return String.valueOf(resultType) + resolvedElementType;
            }
            case 1: {
                return TypeUtil.resolveSignatureRelative(owningType, typeSignature, eraseTypeParameters);
            }
            case 3: {
                TypeUtil.resolveSignatureRelative(owningType, typeSignature, eraseTypeParameters);
            }
        }
        return typeSignature;
    }

    private static String resolveSignatureRelative(IType owningType, String typeSignature, boolean eraseTypeParameters) {
        ITypeParameter typeParam;
        if (typeSignature.charAt(0) == 'L') {
            return typeSignature;
        }
        ArrayList<String> typeParameters = new ArrayList<String>();
        IType resolvedType = TypeUtil.resolveTypeRelative(owningType, typeSignature);
        if (resolvedType != null) {
            if (!eraseTypeParameters) {
                String[] stringArray = Signature.getTypeArguments((String)typeSignature);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String typeParam2 = stringArray[n2];
                    typeParameters.add(TypeUtil.resolveSignatureRelative(owningType, typeParam2, eraseTypeParameters));
                    ++n2;
                }
            }
            String resolvedTypeSignature = Signature.createTypeSignature((String)resolvedType.getFullyQualifiedName(), (boolean)true);
            if (typeParameters.size() > 0 && !eraseTypeParameters) {
                StringBuffer sb = new StringBuffer(resolvedTypeSignature);
                if (sb.charAt(sb.length() - 1) == ';') {
                    sb = sb.delete(sb.length() - 1, sb.length());
                }
                sb.append("<");
                for (String param : typeParameters) {
                    sb.append(param);
                }
                sb.append(">;");
                return sb.toString();
            }
            return resolvedTypeSignature;
        }
        if ((Signature.getTypeSignatureKind((String)typeSignature) == 1 || Signature.getTypeSignatureKind((String)typeSignature) == 3) && (typeParam = owningType.getTypeParameter(Signature.getSignatureSimpleName((String)typeSignature))).exists()) {
            return "Ljava.lang.Object;";
        }
        return typeSignature;
    }

    private static IType resolveTypeRelative(IType owningType, String typeSignature) {
        String fullName = TypeUtil.getFullyQualifiedName(typeSignature);
        IType resolvedType = null;
        try {
            String[][] resolved = owningType.resolveType(fullName);
            resolvedType = resolved != null && resolved.length > 0 ? owningType.getJavaProject().findType(resolved[0][0], resolved[0][1]) : TypeUtil.resolveInParents(owningType, fullName);
        }
        catch (JavaModelException javaModelException) {}
        return resolvedType;
    }

    public static String getSignature(IType type) {
        String fullyQualifiedName = type.getFullyQualifiedName();
        return Signature.createTypeSignature((String)fullyQualifiedName, (boolean)true);
    }

    public static String resolveMethodSignature(IType owner, String unresolvedSignature) {
        String[] parameters = Signature.getParameterTypes((String)unresolvedSignature);
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = TypeUtil.resolveTypeSignature(owner, parameters[i]);
            ++i;
        }
        String resolvedReturn = TypeUtil.resolveTypeSignature(owner, Signature.getReturnType((String)unresolvedSignature));
        return Signature.createMethodSignature((String[])parameters, (String)resolvedReturn);
    }

    public static String getFullyQualifiedName(String typeSignature) {
        String packageName = Signature.getSignatureQualifier((String)typeSignature);
        String typeName = Signature.getSignatureSimpleName((String)typeSignature);
        return "".equals(packageName) ? typeName : String.valueOf(packageName) + "." + typeName;
    }

    private static IType resolveInParents(IType childType, String fullyQualifiedName) throws JavaModelException {
        IType resolvedType = null;
        ITypeHierarchy typeHierarchy = childType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType[] superTypes = typeHierarchy.getAllSupertypes(childType);
        int i = 0;
        while (i < superTypes.length) {
            IType type = superTypes[i];
            String[][] resolved = type.resolveType(fullyQualifiedName);
            if (resolved != null && resolved.length > 0) {
                resolvedType = childType.getJavaProject().findType(resolved[0][0], resolved[0][1]);
                break;
            }
            ++i;
        }
        return resolvedType;
    }

    public static IType resolveType(IJavaProject javaProject, String fullyResolvedTypeSignature) {
        String fullyQualifiedName = TypeUtil.getFullyQualifiedName(fullyResolvedTypeSignature);
        try {
            return javaProject.findType(fullyQualifiedName);
        }
        catch (JavaModelException e) {
            JSFCommonPlugin.log(e);
            return null;
        }
    }

    public static String matchTypeParameterToArgument(IType type, String typeParamSignature, List<String> typeArguments) {
        try {
            ITypeParameter[] typeParams = type.getTypeParameters();
            int pos = 0;
            while (pos < typeParams.length) {
                if (typeParams[pos].getElementName().equals(Signature.getSignatureSimpleName((String)typeParamSignature)) && pos < typeArguments.size()) {
                    return typeArguments.get(pos);
                }
                ++pos;
            }
        }
        catch (JavaModelException e) {
            JSFCommonPlugin.log(e);
        }
        return null;
    }

    public static boolean isEnumMember(IType type, String fieldName) {
        block6: {
            try {
                if (type == null || !TypeUtil.isEnumType(type)) {
                    throw new IllegalArgumentException("type must be non-null and isEnum()==true");
                }
                if (fieldName == null) {
                    throw new IllegalArgumentException("fieldName must be non-null");
                }
                if (!"Ljava.lang.Enum;".equals(Signature.createTypeSignature((String)type.getFullyQualifiedName(), (boolean)true))) break block6;
                return true;
            }
            catch (JavaModelException javaModelException) {}
        }
        IField field = type.getField(fieldName);
        if (field.exists() && field.isEnumConstant()) {
            return true;
        }
        return false;
    }

    public static boolean isEnumsCompareCompatible(String typeSig1, String typeSig2) {
        if (typeSig1 == null || typeSig2 == null) {
            throw new IllegalArgumentException("args must not be null");
        }
        if (Signature.getTypeSignatureKind((String)typeSig1) != 1 || Signature.getTypeSignatureKind((String)typeSig2) != 1) {
            throw new IllegalArgumentException("args must be resolved class types");
        }
        if ("Ljava.lang.Enum;".equals(typeSig1) || "Ljava.lang.Enum;".equals(typeSig2)) {
            return true;
        }
        return typeSig1.equals(typeSig2);
    }

    public static boolean canNeverBeEqual(String typeSig1, String typeSig2) {
        if (typeSig1 == null || typeSig2 == null) {
            throw new IllegalArgumentException("args must not be null");
        }
        if (Signature.getTypeSignatureKind((String)typeSig1) != 1 || Signature.getTypeSignatureKind((String)typeSig2) != 1) {
            throw new IllegalArgumentException("args must be resolved class types");
        }
        if ("Ljava.lang.Enum;".equals(typeSig1) || "Ljava.lang.Enum;".equals(typeSig2)) {
            return false;
        }
        return !typeSig1.equals(typeSig2);
    }

    static boolean isEnumType(IType type) {
        if (type == null) {
            return false;
        }
        if ("Ljava.lang.Enum;".equals(Signature.createTypeSignature((String)type.getFullyQualifiedName(), (boolean)true))) {
            return true;
        }
        try {
            return type.isEnum();
        }
        catch (JavaModelException jme) {
            JSFCommonPlugin.log((Exception)((Object)jme), "Problem resolving isEnum");
            return false;
        }
    }
}

