/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationConstants;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public abstract class ValidationConfiguration
implements Preferences.IPropertyChangeListener {
    private IResource _resource;
    private boolean disableAllValidation = this.getDisableAllValidation();
    private String _version;
    private Map _validators = new HashMap();
    protected HashMap manualValidators;
    protected HashMap buildValidators;
    protected String USER_PREFERENCE = "USER_PREFERENCE";
    protected String USER_MANUAL_PREFERENCE = "USER_MANUAL_PREFERENCE";
    protected String USER_BUILD_PREFERENCE = "USER_BUILD_PREFERENCE";
    protected String DELEGATES_PREFERENCE = "DELEGATES_PREFERENCE";
    private Map _delegatesByTarget = new HashMap();

    public static String getEnabledElementsAsString(Set elements) {
        if (elements == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            buffer.append(((ValidatorMetaData)iterator.next()).getValidatorUniqueName());
            buffer.append(";");
        }
        return buffer.toString();
    }

    private boolean getDisableAllValidation() {
        return false;
    }

    public static String getEnabledElementsAsString(Object[] elements) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            buffer.append(((ValidatorMetaData)elements[i]).getValidatorUniqueName());
            buffer.append(";");
            ++i;
        }
        return buffer.toString();
    }

    public static Set getStringAsEnabledElements(String elements) {
        if (elements == null) {
            return null;
        }
        HashSet<ValidatorMetaData> result = new HashSet<ValidatorMetaData>();
        StringTokenizer tokenizer = new StringTokenizer(elements, ";");
        while (tokenizer.hasMoreTokens()) {
            String elem = tokenizer.nextToken();
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(elem);
            if (vmd == null) continue;
            result.add(vmd);
        }
        return result;
    }

    public static ValidatorMetaData[] getStringAsEnabledElementsArray(String elements) {
        if (elements == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(elements, ";");
        ValidatorMetaData[] result = new ValidatorMetaData[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String elem = tokenizer.nextToken();
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(elem);
            if (vmd == null) continue;
            result[count++] = vmd;
        }
        if (count != result.length) {
            ValidatorMetaData[] trimResult = new ValidatorMetaData[count];
            System.arraycopy(result, 0, trimResult, 0, count);
            return trimResult;
        }
        return result;
    }

    public static IWorkspaceRoot getRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected ValidationConfiguration() throws InvocationTargetException {
    }

    protected ValidationConfiguration(IResource resource, ValidatorMetaData[] validators) throws InvocationTargetException {
        this();
        if (resource == null) {
            throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLCREATE"));
        }
        this.setResource(resource);
        this.setValidators(validators);
    }

    private void setResource(IResource resource) {
        this._resource = resource;
    }

    public boolean isDisableAllValidation() throws InvocationTargetException {
        return this.disableAllValidation;
    }

    public void setDisableAllValidation(boolean allValidation) {
        this.disableAllValidation = allValidation;
    }

    public ValidatorMetaData[] getEnabledValidators() throws InvocationTargetException {
        return this.getValidators(true);
    }

    public ValidatorMetaData[] getEnabledIncrementalValidators(boolean incremental) throws InvocationTargetException {
        return this.getEnabledFullBuildValidators(!incremental);
    }

    public ValidatorMetaData[] getEnabledFullBuildValidators(boolean fullBuild) throws InvocationTargetException {
        return this.getEnabledFullBuildValidators(fullBuild, false);
    }

    public ValidatorMetaData[] getEnabledFullBuildValidators(boolean fullBuild, boolean onlyReferenced) throws InvocationTargetException {
        int count = 0;
        ValidatorMetaData[] result = null;
        if (!this.isDisableAllValidation()) {
            ValidatorMetaData[] temp = new ValidatorMetaData[this.numberOfValidators()];
            Iterator iterator = this.getBuildEnabledValidatorsMap().keySet().iterator();
            while (iterator.hasNext()) {
                ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
                Boolean bvalue = (Boolean)this.getBuildEnabledValidatorsMap().get(vmd);
                if (!bvalue.booleanValue() || vmd == null || !vmd.isBuildValidation() || onlyReferenced && !vmd.isDependentValidator()) continue;
                temp[count++] = vmd;
            }
            result = new ValidatorMetaData[count];
            System.arraycopy(temp, 0, result, 0, count);
        } else {
            result = new ValidatorMetaData[]{};
        }
        return result;
    }

    public void setEnabledValidators(ValidatorMetaData[] vmds) {
        Map all = this.getValidatorMetaData();
        Iterator iterator = all.keySet().iterator();
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            all.put(vmd, Boolean.FALSE);
        }
        if (vmds == null || vmds.length == 0) {
            return;
        }
        int i = 0;
        while (i < vmds.length) {
            all.put(vmds[i], Boolean.TRUE);
            ++i;
        }
    }

    public void setEnabledManualValidators(ValidatorMetaData[] vmds) throws InvocationTargetException {
        List<ValidatorMetaData> manualEnabledVMDList = Arrays.asList(vmds);
        List<ValidatorMetaData> allValidators = Arrays.asList(this.getValidators());
        int i = 0;
        while (i < allValidators.size()) {
            ValidatorMetaData data = allValidators.get(i);
            if (manualEnabledVMDList.contains(data)) {
                this.getManualEnabledValidatorsMap().put(data, new Boolean(true));
            } else {
                this.getManualEnabledValidatorsMap().put(data, new Boolean(false));
            }
            ++i;
        }
    }

    public void setEnabledBuildValidators(ValidatorMetaData[] vmds) throws InvocationTargetException {
        List<ValidatorMetaData> buildEnabledVMDList = Arrays.asList(vmds);
        List<ValidatorMetaData> allValidators = Arrays.asList(this.getValidators());
        int i = 0;
        while (i < allValidators.size()) {
            ValidatorMetaData data = allValidators.get(i);
            if (buildEnabledVMDList.contains(data)) {
                this.getBuildEnabledValidatorsMap().put(data, new Boolean(true));
            } else {
                this.getBuildEnabledValidatorsMap().put(data, new Boolean(false));
            }
            ++i;
        }
    }

    private Map getValidatorMetaData() {
        return this._validators;
    }

    public ValidatorMetaData[] getDisabledValidators() throws InvocationTargetException {
        return this.getValidators(false);
    }

    private ValidatorMetaData[] getValidators(boolean value) throws InvocationTargetException {
        ValidatorMetaData[] temp = new ValidatorMetaData[this.numberOfValidators()];
        Iterator iterator = this.getValidatorMetaData().keySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            Boolean bvalue = (Boolean)this.getValidatorMetaData().get(vmd);
            if (bvalue != value) continue;
            temp[count++] = vmd;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public ValidatorMetaData[] getManualEnabledValidators() throws InvocationTargetException {
        HashMap map = this.getManualEnabledValidatorsMap();
        Set set = this.getManualEnabledValidatorsMap().keySet();
        if (!set.isEmpty()) {
            Iterator it = set.iterator();
            ArrayList<ValidatorMetaData> enabledManualValidators = new ArrayList<ValidatorMetaData>();
            while (it.hasNext()) {
                ValidatorMetaData data = (ValidatorMetaData)it.next();
                Boolean obj = (Boolean)map.get(data);
                if (obj == null || !obj.booleanValue()) continue;
                enabledManualValidators.add(data);
            }
            return enabledManualValidators.toArray(new ValidatorMetaData[enabledManualValidators.size()]);
        }
        return this.getEnabledValidators();
    }

    public ValidatorMetaData[] getBuildEnabledValidators() throws InvocationTargetException {
        HashMap map = this.getBuildEnabledValidatorsMap();
        Set set = this.getBuildEnabledValidatorsMap().keySet();
        Iterator it = set.iterator();
        ArrayList<ValidatorMetaData> enabledBuildValidators = new ArrayList<ValidatorMetaData>();
        if (!set.isEmpty()) {
            while (it.hasNext()) {
                ValidatorMetaData data = (ValidatorMetaData)it.next();
                Boolean obj = (Boolean)map.get(data);
                if (obj == null || !obj.booleanValue()) continue;
                enabledBuildValidators.add(data);
            }
            return enabledBuildValidators.toArray(new ValidatorMetaData[enabledBuildValidators.size()]);
        }
        return this.getEnabledValidators();
    }

    protected HashMap getBuildEnabledValidatorsMap() {
        if (this.buildValidators == null) {
            this.buildValidators = new HashMap();
        }
        return this.buildValidators;
    }

    protected HashMap getManualEnabledValidatorsMap() {
        if (this.manualValidators == null) {
            this.manualValidators = new HashMap();
        }
        return this.manualValidators;
    }

    public ValidatorMetaData[] getIncrementalValidators() throws InvocationTargetException {
        ValidatorMetaData[] temp = new ValidatorMetaData[this.numberOfValidators()];
        Iterator iterator = this.getValidatorMetaData().keySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            Boolean bvalue = (Boolean)this.getValidatorMetaData().get(vmd);
            if (!bvalue.booleanValue() || !vmd.isIncremental()) continue;
            temp[count++] = vmd;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public ValidatorMetaData[] getValidators() throws InvocationTargetException {
        return ValidationConfiguration.convertToArray(this._validators.keySet());
    }

    public void setValidators(ValidatorMetaData[] vmds) {
        this._validators.clear();
        int i = 0;
        while (i < vmds.length) {
            if (vmds[i] != null) {
                this._validators.put(vmds[i], vmds[i].isEnabledByDefault() ? Boolean.TRUE : Boolean.FALSE);
            }
            ++i;
        }
    }

    public void setDefaultDelegates(ValidatorMetaData[] vmds) throws InvocationTargetException {
        this._delegatesByTarget.clear();
        int i = 0;
        while (i < vmds.length) {
            ValidatorMetaData vmd = vmds[i];
            if (vmd != null) {
                String targetID = vmd.getValidatorUniqueName();
                String delegateID = ValidatorDelegatesRegistry.getInstance().getDefaultDelegate(targetID);
                if (delegateID != null) {
                    this._delegatesByTarget.put(targetID, ValidatorDelegatesRegistry.getInstance().getDefaultDelegate(targetID));
                }
            }
            ++i;
        }
    }

    public int numberOfValidators() throws InvocationTargetException {
        return this._validators.size();
    }

    public int numberOfEnabledIncrementalValidators() throws InvocationTargetException {
        return ValidationConfiguration.numberOfIncrementalValidators(this.getEnabledValidators());
    }

    public int numberOfIncrementalValidators() throws InvocationTargetException {
        return ValidationConfiguration.numberOfIncrementalValidators(this.getValidators());
    }

    private static int numberOfIncrementalValidators(ValidatorMetaData[] vmds) {
        int count = 0;
        int i = 0;
        while (i < vmds.length) {
            ValidatorMetaData vmd = vmds[i];
            if (vmd.isIncremental()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int numberOfEnabledValidators() throws InvocationTargetException {
        return this.getEnabledValidators().length;
    }

    public int numberOfDisabledValidators() throws InvocationTargetException {
        return this.getDisabledValidators().length;
    }

    public final String getVersion() throws InvocationTargetException {
        if (this._version == null) {
            this.loadVersion();
        }
        return this._version;
    }

    private void setVersion(String version) {
        this._version = version;
    }

    public void markVersionCurrent() {
        this.setVersion(ConfigurationConstants.CURRENT_VERSION);
    }

    public boolean isVersionCurrent() throws InvocationTargetException {
        return this.getVersion().equals(ConfigurationConstants.CURRENT_VERSION);
    }

    public IResource getResource() {
        return this._resource;
    }

    public boolean isEnabled(String validatorClassName) throws InvocationTargetException {
        if (validatorClassName == null) {
            return false;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorClassName);
        return this.isEnabled(vmd);
    }

    public boolean isEnabled(ValidatorMetaData vmd) throws InvocationTargetException {
        if (vmd == null) {
            return false;
        }
        Boolean value = (Boolean)this.getValidatorMetaData().get(vmd);
        if (value == null) {
            return false;
        }
        return value;
    }

    public final void passivate() throws InvocationTargetException {
        try {
            if (this.getResource() == null) {
                throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLSAVE"));
            }
            this.getResource().setSessionProperty(ConfigurationConstants.USER_PREFERENCE, (Object)this);
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_SAVE", new String[]{this.getResource().getName()}));
        }
    }

    public abstract void resetToDefault() throws InvocationTargetException;

    protected Boolean convertToBoolean(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Integer convertToInteger(int value) {
        return new Integer(value);
    }

    protected boolean convertToBoolean(String value) {
        Boolean b = Boolean.valueOf(value);
        return b;
    }

    protected int convertToInt(String value) {
        Integer t = Integer.valueOf(value);
        return t;
    }

    public static ValidatorMetaData[] convertToArray(Collection c) {
        int length = c == null ? 0 : c.size();
        ValidatorMetaData[] result = new ValidatorMetaData[length];
        if (length == 0) {
            return result;
        }
        Iterator iterator = c.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            result[count++] = vmd;
        }
        return result;
    }

    public static ValidatorMetaData[] convertToArray(Object[] c) {
        int length = c == null ? 0 : c.length;
        ValidatorMetaData[] result = new ValidatorMetaData[length];
        if (length == 0) {
            return result;
        }
        System.arraycopy(c, 0, result, 0, length);
        return result;
    }

    public void store() throws InvocationTargetException {
        Preferences pref = ValidationPlugin.getPlugin().getPluginPreferences();
        if (pref != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                pref.setValue(this.USER_PREFERENCE, this.serialize());
                pref.store((OutputStream)os, this.USER_PREFERENCE);
                pref.setValue(this.USER_MANUAL_PREFERENCE, this.serializeManualSetting());
                pref.store((OutputStream)os, this.USER_MANUAL_PREFERENCE);
                pref.setValue(this.USER_BUILD_PREFERENCE, this.serializeBuildSetting());
                pref.store((OutputStream)os, this.USER_BUILD_PREFERENCE);
                pref.setValue(this.DELEGATES_PREFERENCE, this.serializeDelegatesSetting());
                pref.store((OutputStream)os, this.DELEGATES_PREFERENCE);
            }
            catch (IOException ie) {
                Logger.getLogger().log((Throwable)ie);
            }
        }
    }

    protected final void loadVersion() throws InvocationTargetException {
        if (this.getResource() == null) {
            throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLRETRIEVE"));
        }
        IMarker[] marker = this.getMarker();
        String version = null;
        version = marker == null ? this.loadVersion(this.getResource()) : this.loadVersion(marker);
        this.setVersion(version);
    }

    protected final String loadVersion(IMarker[] marker) throws InvocationTargetException {
        String version = (String)this.getValue(marker[0], "version");
        if (version == null) {
            return "4.03";
        }
        return version;
    }

    protected final String loadVersion(IResource resource) throws InvocationTargetException {
        try {
            String storedConfiguration = resource.getPersistentProperty(ConfigurationConstants.USER_PREFERENCE);
            String version = null;
            if (storedConfiguration == null) {
                version = ValidationConfiguration.getVersionDefault();
            } else {
                int versionIndex = storedConfiguration.indexOf("version");
                if (versionIndex != -1) {
                    version = storedConfiguration.substring(versionIndex + "version".length());
                }
            }
            if (version == null) {
                return ValidationConfiguration.getVersionDefault();
            }
            return version;
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{this.getResource().getName()}));
        }
    }

    protected final void load() throws InvocationTargetException {
        try {
            if (this.getResource() == null) {
                throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLRETRIEVE"));
            }
            IMarker[] marker = this.getMarker();
            if (marker == null) {
                this.loadPreference();
            } else {
                this.load(marker);
            }
        }
        catch (InvocationTargetException exc) {
            throw exc;
        }
        catch (Exception exc) {
            String resourceName = this.getResource() == null ? "null" : this.getResource().getName();
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{resourceName}));
        }
    }

    protected abstract IMarker[] getMarker();

    protected abstract void load(IMarker[] var1) throws InvocationTargetException;

    protected Object getValue(IMarker marker, String attribName) {
        if (marker == null) {
            return null;
        }
        try {
            return marker.getAttribute(attribName);
        }
        catch (CoreException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidationConfiguration::getValue(" + attribName + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return null;
        }
    }

    protected boolean getValue(IMarker marker, String attribName, boolean defaultValue) {
        Boolean bool = (Boolean)this.getValue(marker, attribName);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }

    protected int getValue(IMarker marker, String attribName, int defaultValue) {
        Integer integer = (Integer)this.getValue(marker, attribName);
        if (integer == null) {
            return defaultValue;
        }
        return integer;
    }

    protected String getValue(IMarker marker, String attribName, String defaultValue) {
        String string = (String)this.getValue(marker, attribName);
        if (string == null) {
            return defaultValue;
        }
        return string;
    }

    protected void loadPreference() throws InvocationTargetException {
        Preferences prefs = ValidationPlugin.getPlugin().getPluginPreferences();
        if (prefs != null) {
            this.deserializeAllPrefs(prefs);
        }
    }

    private void deserializeAllPrefs(Preferences prefs) throws InvocationTargetException {
        String storedConfig = prefs.getString(this.USER_PREFERENCE);
        this.deserialize(storedConfig);
        String storedManualConfig = prefs.getString(this.USER_MANUAL_PREFERENCE);
        this.deserializeManual(storedManualConfig);
        String storedBuildConfig = prefs.getString(this.USER_BUILD_PREFERENCE);
        this.deserializeBuild(storedBuildConfig);
        String storedDelegatesConfiguration = prefs.getString(this.DELEGATES_PREFERENCE);
        this.deserializeDelegates(storedDelegatesConfiguration);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        Preferences prefs = (Preferences)event.getSource();
        if (prefs != null && !event.getOldValue().equals(event.getNewValue())) {
            try {
                this.deserializeAllPrefs(event);
                this.passivate();
            }
            catch (InvocationTargetException ie) {
                Logger.getLogger().log((Throwable)ie);
            }
        }
    }

    private void deserializeAllPrefs(Preferences.PropertyChangeEvent event) throws InvocationTargetException {
        String storedConfig = (String)event.getNewValue();
        if (event.getProperty().equals(this.USER_PREFERENCE)) {
            this.deserialize(storedConfig);
        } else if (event.getProperty().equals(this.USER_MANUAL_PREFERENCE)) {
            this.deserializeManual(storedConfig);
        } else if (event.getProperty().equals(this.USER_BUILD_PREFERENCE)) {
            this.deserializeBuild(storedConfig);
        } else if (event.getProperty().equals(this.DELEGATES_PREFERENCE)) {
            this.deserializeDelegates(storedConfig);
        }
    }

    protected void deserializeBuild(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null || storedConfiguration.length() == 0 || storedConfiguration.equals("default_value")) {
            this.resetToDefault();
            return;
        }
        int buildValidationIndex = storedConfiguration.indexOf("enabledBuildValidatorList");
        String manualValidation = storedConfiguration.substring(buildValidationIndex + "enabledBuildValidatorList".length(), storedConfiguration.length());
        this.setEnabledBuildValidators(ValidationConfiguration.getStringAsEnabledElementsArray(manualValidation));
    }

    protected void deserializeManual(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null || storedConfiguration.length() == 0 || storedConfiguration.equals("default_value")) {
            this.resetToDefault();
            return;
        }
        int manualValidationIndex = storedConfiguration.indexOf("enabledManualValidatorList");
        String manualValidation = storedConfiguration.substring(manualValidationIndex + "enabledManualValidatorList".length(), storedConfiguration.length());
        this.setEnabledManualValidators(ValidationConfiguration.getStringAsEnabledElementsArray(manualValidation));
    }

    protected void deserializeDelegates(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null || storedConfiguration.length() == 0 || storedConfiguration.equals("default_value")) {
            this.resetToDefault();
            return;
        }
        int delegatesIndex = storedConfiguration.indexOf("delegateValidatorList");
        String delegates = storedConfiguration.substring(delegatesIndex + "delegateValidatorList".length(), storedConfiguration.length());
        if (delegates == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(delegates, ";");
        while (tokenizer.hasMoreTokens()) {
            String delegateConfiguration = tokenizer.nextToken();
            int separatorIndex = delegateConfiguration.indexOf("=");
            String targetID = delegateConfiguration.substring(0, separatorIndex);
            String delegateID = delegateConfiguration.substring(separatorIndex + 1);
            this._delegatesByTarget.put(targetID, delegateID);
        }
    }

    protected void copyTo(ValidationConfiguration up) throws InvocationTargetException {
        up.setVersion(this.getVersion());
        up.setResource(this.getResource());
        up.setValidators(this.getValidators());
        up.setDisableAllValidation(this.isDisableAllValidation());
        up.setEnabledValidators(this.getEnabledValidators());
        up.setEnabledManualValidators(this.getManualEnabledValidators());
        up.setEnabledBuildValidators(this.getBuildEnabledValidators());
        up.setDelegatingValidators(this.getDelegatingValidators());
    }

    public Map getDelegatingValidators() throws InvocationTargetException {
        return this._delegatesByTarget;
    }

    public void setDelegatingValidators(Map source) {
        this._delegatesByTarget.putAll(source);
    }

    protected boolean hasEnabledValidatorsChanged(ValidatorMetaData[] oldEnabledVmd) throws InvocationTargetException {
        if (oldEnabledVmd == null) {
            return true;
        }
        int i = 0;
        while (i < oldEnabledVmd.length) {
            ValidatorMetaData vmd = oldEnabledVmd[i];
            if (!this.isEnabled(vmd)) {
                return true;
            }
            ++i;
        }
        return this.numberOfEnabledValidators() != oldEnabledVmd.length;
    }

    protected boolean haveDelegatesChanged(Map oldDelegates) throws InvocationTargetException {
        if (oldDelegates == null) {
            return true;
        }
        Iterator iterator = oldDelegates.keySet().iterator();
        while (iterator.hasNext()) {
            String targetID = (String)iterator.next();
            String oldDelegateID = (String)oldDelegates.get(targetID);
            String newDelegateID = (String)this._delegatesByTarget.get(targetID);
            if (oldDelegateID == null || newDelegateID == null) {
                return true;
            }
            if (newDelegateID.equals(oldDelegateID)) continue;
            return true;
        }
        return oldDelegates.size() != this._delegatesByTarget.size();
    }

    protected String serialize() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("disableAllValidation");
        buffer.append(String.valueOf(this.isDisableAllValidation()));
        buffer.append("version");
        buffer.append(this.getVersion());
        return buffer.toString();
    }

    protected String serializeManualSetting() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("enabledManualValidatorList");
        buffer.append(ValidationConfiguration.getEnabledElementsAsString(this.getManualEnabledValidators()));
        return buffer.toString();
    }

    protected String serializeBuildSetting() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("enabledBuildValidatorList");
        buffer.append(ValidationConfiguration.getEnabledElementsAsString(this.getBuildEnabledValidators()));
        return buffer.toString();
    }

    protected String serializeDelegatesSetting() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("delegateValidatorList");
        buffer.append(this.getDelegatesAsString(this.getValidatorMetaData()));
        return buffer.toString();
    }

    private String getDelegatesAsString(Map validatorMetaData) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = validatorMetaData.keySet().iterator();
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            String targetID = vmd.getValidatorUniqueName();
            String delegateID = this.getDelegateUniqueName(vmd);
            if (delegateID == null) continue;
            buffer.append(targetID);
            buffer.append("=");
            buffer.append(delegateID);
            buffer.append(";");
        }
        return buffer.toString();
    }

    public String getDelegateUniqueName(ValidatorMetaData vmd) {
        String targetID = vmd.getValidatorUniqueName();
        return (String)this._delegatesByTarget.get(targetID);
    }

    public void setDelegateUniqueName(ValidatorMetaData vmd, String delegateID) {
        String targetID = vmd.getValidatorUniqueName();
        this._delegatesByTarget.put(targetID, delegateID);
    }

    protected void deserialize(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null || storedConfiguration.length() == 0 || storedConfiguration.equals("default_value")) {
            this.resetToDefault();
            return;
        }
        int disableAllValidationIndex = storedConfiguration.indexOf("disableAllValidation");
        int versionIndex = storedConfiguration.indexOf("version");
        if (disableAllValidationIndex != -1) {
            String disableAllValidation = storedConfiguration.substring(disableAllValidationIndex + "disableAllValidation".length(), versionIndex);
            this.setDisableAllValidation(Boolean.valueOf(disableAllValidation));
        } else {
            this.setDisableAllValidation(false);
        }
    }

    public static boolean getDisableValidationDefault() {
        return false;
    }

    public static ValidatorMetaData[] getEnabledValidatorsDefault() {
        return ConfigurationConstants.DEFAULT_ENABLED_VALIDATORS;
    }

    public static int getMaximumNumberOfMessagesDefault() {
        return 50;
    }

    public static String getVersionDefault() {
        return ConfigurationConstants.CURRENT_VERSION;
    }

    public boolean isManualEnabled(ValidatorMetaData vmd) {
        if (vmd == null) {
            return false;
        }
        Boolean value = (Boolean)this.getManualEnabledValidatorsMap().get(vmd);
        if (value == null) {
            return false;
        }
        return value;
    }

    public boolean isBuildEnabled(ValidatorMetaData vmd) {
        if (vmd == null) {
            return false;
        }
        Boolean value = (Boolean)this.getBuildEnabledValidatorsMap().get(vmd);
        if (value == null) {
            return false;
        }
        return value;
    }

    public int numberOfManualEnabledValidators() throws InvocationTargetException {
        return this.getManualEnabledValidators().length;
    }

    public void enableSingleValidator(ValidatorMetaData vmd) {
        Map all = this.getValidatorMetaData();
        all.put(vmd, Boolean.TRUE);
    }

    public void disableSingleValidator(ValidatorMetaData vmd) {
        Map all = this.getValidatorMetaData();
        all.put(vmd, Boolean.FALSE);
    }

    public void enableSingleManualValidator(ValidatorMetaData vmd) {
        HashMap manVal = this.getManualEnabledValidatorsMap();
        manVal.put(vmd, Boolean.TRUE);
    }

    public void disableSingleManualValidator(ValidatorMetaData vmd) {
        HashMap manVal = this.getManualEnabledValidatorsMap();
        manVal.put(vmd, Boolean.FALSE);
    }

    public void enableSingleBuildValidator(ValidatorMetaData vmd) {
        HashMap buildVal = this.getBuildEnabledValidatorsMap();
        buildVal.put(vmd, Boolean.TRUE);
    }

    public void disableSingleBuildValidator(ValidatorMetaData vmd) {
        HashMap buildVal = this.getBuildEnabledValidatorsMap();
        buildVal.put(vmd, Boolean.FALSE);
    }

    public ValidatorDelegateDescriptor getDelegateDescriptor(ValidatorMetaData vmd) throws InvocationTargetException {
        String targetID = vmd.getValidatorUniqueName();
        String delegateID = this.getDelegateUniqueName(vmd);
        ValidatorDelegateDescriptor descriptor = ValidatorDelegatesRegistry.getInstance().getDescriptor(targetID, delegateID);
        return descriptor;
    }
}

