/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jst.server.core.PublishUtil;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;

public class PublishOperation2
extends PublishOperation {
    protected TomcatServerBehaviour server;
    protected IModule[] module;
    protected int kind;
    protected int deltaKind;

    public PublishOperation2(TomcatServerBehaviour server, int kind, IModule[] module, int deltaKind) {
        super("Publish to server", "Publish Web module to Tomcat server");
        this.server = server;
        this.module = module;
        this.kind = kind;
        this.deltaKind = deltaKind;
    }

    public int getOrder() {
        return 0;
    }

    public int getKind() {
        return 2;
    }

    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        ArrayList status = new ArrayList();
        if (this.module.length == 1) {
            this.publishDir(this.module[0], status, monitor);
        } else {
            this.publishJar(status, monitor);
        }
        PublishOperation2.throwException(status);
        this.server.setModulePublishState2(this.module, 1);
    }

    private void publishDir(IModule module2, List status, IProgressMonitor monitor) throws CoreException {
        IStatus[] stat;
        IPath path = this.server.getModuleDeployDirectory(module2);
        if (this.kind == 4 || this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
            File f = path.toFile();
            if (f.exists()) {
                stat = PublishUtil.deleteDirectory((File)f, (IProgressMonitor)monitor);
                PublishOperation2.addArrayToList(status, stat);
            }
            if (this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        if (this.kind == 4 || this.kind == 2) {
            IModuleResource[] mr = this.server.getResources(this.module);
            stat = PublishUtil.publishFull((IModuleResource[])mr, (IPath)path, (IProgressMonitor)monitor);
            PublishOperation2.addArrayToList(status, stat);
            return;
        }
        IModuleResourceDelta[] delta = this.server.getPublishedResourceDelta(this.module);
        int size = delta.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat2 = PublishUtil.publishDelta((IModuleResourceDelta)delta[i], (IPath)path, (IProgressMonitor)monitor);
            PublishOperation2.addArrayToList(status, stat2);
            ++i;
        }
    }

    private void publishJar(List status, IProgressMonitor monitor) throws CoreException {
        IModuleResourceDelta[] delta;
        IPath path = this.server.getModuleDeployDirectory(this.module[0]);
        path = path.append("WEB-INF").append("lib");
        IPath jarPath = path.append(String.valueOf(this.module[1].getName()) + ".jar");
        if (this.kind == 4 || this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
            if (jarPath.toFile().exists()) {
                jarPath.toFile().delete();
            }
            if (this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        if (this.kind != 4 && this.kind != 2 && ((delta = this.server.getPublishedResourceDelta(this.module)) == null || delta.length == 0)) {
            return;
        }
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        IModuleResource[] mr = this.server.getResources(this.module);
        IStatus[] stat = PublishUtil.publishZip((IModuleResource[])mr, (IPath)jarPath, (IProgressMonitor)monitor);
        PublishOperation2.addArrayToList(status, stat);
    }

    protected static void throwException(List status) throws CoreException {
        if (status == null) {
            status = new ArrayList();
        }
        if (status == null || status.size() == 0) {
            return;
        }
        if (status.size() == 1) {
            IStatus status2 = (IStatus)status.get(0);
            throw new CoreException(status2);
        }
        IStatus[] children = new IStatus[status.size()];
        status.toArray(children);
        String message = Messages.errorPublish;
        MultiStatus status2 = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, children, message, null);
        throw new CoreException((IStatus)status2);
    }

    protected static void addArrayToList(List list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }
}

