/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.PublishUtil;
import org.eclipse.jst.server.tomcat.core.internal.IMimeMapping;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatWebModule;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebAppDocument;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.XMLUtil;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Connector;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Parameter;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Server;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.ServerInstance;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.ServerPort;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Tomcat32Configuration
extends TomcatConfiguration {
    protected static final String HTTP_HANDLER = "org.apache.tomcat.service.http.HttpConnectionHandler";
    protected static final String APACHE_HANDLER = "org.apache.tomcat.service.connector.Ajp12ConnectionHandler";
    protected static final String SSL_SOCKET_FACTORY = "org.apache.tomcat.net.SSLSocketFactory";
    protected Server server;
    protected ServerInstance serverInstance;
    protected Factory serverFactory;
    protected boolean isServerDirty;
    protected WebAppDocument webAppDocument;
    protected Document tomcatUsersDocument;
    protected String policyFile;

    public Tomcat32Configuration(IFolder path) {
        super(path);
    }

    public ServerPort getMainPort() {
        Iterator iterator = this.getServerPorts().iterator();
        while (iterator.hasNext()) {
            ServerPort port = (ServerPort)iterator.next();
            if (!port.getName().equals("HTTP Connector")) continue;
            return port;
        }
        return null;
    }

    public String getDocBasePrefix() {
        return "webapps/";
    }

    public List getMimeMappings() {
        if (this.webAppDocument == null) {
            return new ArrayList(0);
        }
        return this.webAppDocument.getMimeMappings();
    }

    public Server getServer() {
        return this.server;
    }

    public List getServerPorts() {
        ArrayList<ServerPort> ports = new ArrayList<ServerPort>();
        try {
            Connector[] connectors = this.serverInstance.getConnectors();
            if (connectors != null) {
                int i = 0;
                while (i < connectors.length) {
                    Connector connector = connectors[i];
                    int paramCount = connector.getParameterCount();
                    String handler = null;
                    String name = Messages.portUnknown;
                    String socketFactory = null;
                    String protocol = "TCPIP";
                    boolean advanced = true;
                    String[] contentTypes = null;
                    int port = -1;
                    int j = 0;
                    while (j < paramCount) {
                        Parameter p = connector.getParameter(j);
                        if ("port".equals(p.getName())) {
                            try {
                                port = Integer.parseInt(p.getValue());
                            }
                            catch (Exception exception) {}
                        } else if ("handler".equals(p.getName())) {
                            handler = p.getValue();
                        } else if ("socketFactory".equals(p.getName())) {
                            socketFactory = p.getValue();
                        }
                        ++j;
                    }
                    if (HTTP_HANDLER.equals(handler)) {
                        protocol = "HTTP";
                        contentTypes = new String[]{"web", "webservices"};
                        if (SSL_SOCKET_FACTORY.equals(socketFactory)) {
                            protocol = "SSL";
                            name = "SSL Connector";
                        } else {
                            name = "HTTP Connector";
                            advanced = false;
                        }
                    } else if (APACHE_HANDLER.equals(handler)) {
                        name = "Apache Connector";
                    }
                    if (handler != null) {
                        ports.add(new ServerPort(String.valueOf(i), name, port, protocol, contentTypes, advanced));
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error getting server ports", e);
        }
        return ports;
    }

    public Document getTomcatUsersDocument() {
        return this.tomcatUsersDocument;
    }

    public List getWebModules() {
        ArrayList<WebModule> list = new ArrayList<WebModule>();
        try {
            Context[] contexts = this.serverInstance.getContexts();
            if (contexts != null) {
                int i = 0;
                while (i < contexts.length) {
                    Context context = contexts[i];
                    String reload = context.getReloadable();
                    if (reload == null) {
                        reload = "false";
                    }
                    WebModule module = new WebModule(context.getPath(), context.getDocBase(), context.getSource(), reload.equalsIgnoreCase("true"));
                    list.add(module);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error getting project refs", e);
        }
        return list;
    }

    public IPath getServerWorkDirectory(IPath basePath) {
        return this.serverInstance.getServerWorkDirectory(basePath);
    }

    public IPath getContextWorkDirectory(IPath basePath, ITomcatWebModule module) {
        Context context = this.serverInstance.getContext(module.getPath());
        if (context != null) {
            return this.serverInstance.getContextWorkDirectory(basePath, context);
        }
        return null;
    }

    public void load(IPath path, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.loadingTask, 5);
            FileInputStream in = new FileInputStream(path.append("tomcat.policy").toFile());
            ((InputStream)in).read();
            ((InputStream)in).close();
            monitor.worked(1);
            this.serverFactory = new Factory();
            this.serverFactory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server32");
            this.server = (Server)this.serverFactory.loadDocument(new FileInputStream(path.append("server.xml").toFile()));
            this.serverInstance = new ServerInstance(this.server);
            monitor.worked(1);
            this.webAppDocument = new WebAppDocument(path.append("web.xml"));
            monitor.worked(1);
            this.tomcatUsersDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(new FileInputStream(path.append("tomcat-users.xml").toFile())));
            monitor.worked(1);
            this.policyFile = TomcatVersionHelper.getFileContents(new FileInputStream(path.append("tomcat.policy").toFile()));
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not load Tomcat v3.2 configuration from " + path.toOSString() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)path.toOSString()), (Throwable)e));
        }
    }

    public void importFromPath(IPath path, boolean isTestEnv, IProgressMonitor monitor) throws CoreException {
        this.load(path, monitor);
        if (isTestEnv) {
            while (this.serverInstance.removeContext(0)) {
            }
        }
    }

    public void load(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.loadingTask, 800);
            IFile file = folder.getFile("tomcat.policy");
            if (!file.exists()) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)folder.getFullPath().toOSString()), null));
            }
            file = folder.getFile("server.xml");
            InputStream in = file.getContents();
            this.serverFactory = new Factory();
            this.serverFactory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server32");
            this.server = (Server)this.serverFactory.loadDocument(in);
            this.serverInstance = new ServerInstance(this.server);
            monitor.worked(200);
            file = folder.getFile("web.xml");
            this.webAppDocument = new WebAppDocument(file);
            monitor.worked(200);
            file = folder.getFile("tomcat-users.xml");
            in = file.getContents();
            this.tomcatUsersDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(in));
            monitor.worked(200);
            file = folder.getFile("tomcat.policy");
            in = file.getContents();
            this.policyFile = TomcatVersionHelper.getFileContents(in);
            monitor.worked(200);
            if (monitor.isCanceled()) {
                throw new Exception("Cancelled");
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not load Tomcat v3.2 configuration from: " + folder.getFullPath() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)folder.getFullPath().toOSString()), (Throwable)e));
        }
    }

    protected void save(IPath path, boolean forceDirty, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.savingTask, 5);
            if (!path.toFile().exists()) {
                forceDirty = true;
                path.toFile().mkdir();
            }
            monitor.worked(1);
            if (forceDirty || this.isServerDirty) {
                this.serverFactory.save(path.append("server.xml").toOSString());
            }
            monitor.worked(1);
            this.webAppDocument.save(path.append("web.xml").toOSString(), forceDirty);
            monitor.worked(1);
            if (forceDirty) {
                XMLUtil.save(path.append("tomcat-users.xml").toOSString(), this.tomcatUsersDocument);
            }
            monitor.worked(1);
            if (forceDirty) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(path.append("tomcat.policy").toFile()));
                bw.write(this.policyFile);
                bw.close();
            }
            monitor.worked(1);
            this.isServerDirty = false;
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not save Tomcat v3.2 configuration to " + path, e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
    }

    public void save(IPath path, IProgressMonitor monitor) throws CoreException {
        this.save(path, true, monitor);
    }

    public void save(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.savingTask, 900);
            if (!folder.exists()) {
                folder.create(true, true, ProgressUtil.getSubMonitorFor(monitor, 100));
            } else {
                monitor.worked(100);
            }
            byte[] data = this.serverFactory.getContents();
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            IFile file = folder.getFile("server.xml");
            if (file.exists()) {
                if (this.isServerDirty) {
                    file.setContents((InputStream)in, true, true, ProgressUtil.getSubMonitorFor(monitor, 200));
                } else {
                    monitor.worked(200);
                }
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            this.isServerDirty = false;
            file = folder.getFile("web.xml");
            this.webAppDocument.save(file, ProgressUtil.getSubMonitorFor(monitor, 200));
            data = XMLUtil.getContents(this.tomcatUsersDocument);
            in = new ByteArrayInputStream(data);
            file = folder.getFile("tomcat-users.xml");
            if (file.exists()) {
                monitor.worked(200);
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            in = new ByteArrayInputStream(this.policyFile.getBytes());
            file = folder.getFile("tomcat.policy");
            if (file.exists()) {
                monitor.worked(200);
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not save Tomcat v3.2 configuration to " + folder.getFullPath(), e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
    }

    public void addMimeMapping(int index, IMimeMapping map) {
        this.webAppDocument.addMimeMapping(index, map);
        this.firePropertyChangeEvent("addMapping", new Integer(index), map);
    }

    public void addWebModule(int index, ITomcatWebModule module) {
        try {
            Context context = this.serverInstance.createContext(index);
            context.setPath(module.getPath());
            context.setDocBase(module.getDocumentBase());
            context.setReloadable(module.isReloadable() ? "true" : "false");
            if (module.getMemento() != null && module.getMemento().length() > 0) {
                context.setSource(module.getMemento());
            }
            this.isServerDirty = true;
            this.firePropertyChangeEvent("addWebModule", null, module);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error adding web module", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus localizeConfiguration(IPath baseDir, IPath deployDir, TomcatServer server2, IProgressMonitor monitor) {
        block24: {
            IStatus iStatus;
            block23: {
                MultiStatus multiStatus;
                block22: {
                    IStatus iStatus2;
                    block20: {
                        try {
                            try {
                                monitor = ProgressUtil.getMonitorFor(monitor);
                                monitor.beginTask(Messages.updatingConfigurationTask, 100);
                                IPath confDir = baseDir.append("conf");
                                Tomcat32Configuration config = new Tomcat32Configuration(null);
                                config.load(confDir, ProgressUtil.getSubMonitorFor(monitor, 300));
                                if (monitor.isCanceled()) {
                                    iStatus2 = Status.CANCEL_STATUS;
                                    Object var19_12 = null;
                                    break block20;
                                }
                                if (server2.isTestEnvironment()) {
                                    config.server.getContextManager().setHome(baseDir.toOSString());
                                    config.isServerDirty = true;
                                }
                                boolean addRootWebapp = server2.isTestEnvironment();
                                boolean deployingToWebapps = "webapps".equals(server2.getDeployDirectory());
                                HashMap<String, String> pathMap = new HashMap<String, String>();
                                MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishServer, (Object)server2.getServer().getName()), null);
                                Context[] contexts = config.serverInstance.getContexts();
                                if (contexts != null) {
                                    int i = 0;
                                    while (i < contexts.length) {
                                        String name;
                                        String source;
                                        Context context = contexts[i];
                                        String path = context.getPath();
                                        if (path != null) {
                                            String lcPath;
                                            String origPath = path;
                                            if ("/".equals(path)) {
                                                if (Trace.isTraceEnabled()) {
                                                    Trace.trace((byte)4, "Context path is being changed from \"/\" to \"\".");
                                                }
                                                path = "";
                                                context.setPath(path);
                                                config.isServerDirty = true;
                                            }
                                            if (!pathMap.containsKey(lcPath = path.toLowerCase())) {
                                                pathMap.put(lcPath, origPath);
                                            } else {
                                                String otherPath = (String)pathMap.get(lcPath);
                                                Status s = new Status(4, "org.eclipse.jst.server.tomcat.core", origPath.equals(otherPath) ? NLS.bind((String)Messages.errorPublishPathDup, (Object)origPath) : NLS.bind((String)Messages.errorPublishPathConflict, (Object)origPath, (Object)otherPath));
                                                ms.add((IStatus)s);
                                            }
                                        } else {
                                            Status s = new Status(4, "org.eclipse.jst.server.tomcat.core", Messages.errorPublishPathMissing);
                                            ms.add((IStatus)s);
                                        }
                                        if (addRootWebapp && "".equals(context.getPath())) {
                                            addRootWebapp = false;
                                        }
                                        if (!deployingToWebapps && (source = context.getSource()) != null && source.length() > 0 && (name = context.getDocBase()).startsWith(this.getDocBasePrefix())) {
                                            name = name.substring(this.getDocBasePrefix().length());
                                            context.setDocBase(deployDir.append(name).toOSString());
                                            config.isServerDirty = true;
                                        }
                                        ++i;
                                    }
                                }
                                if (!ms.isOK()) {
                                    multiStatus = ms;
                                    break block22;
                                }
                                if (addRootWebapp) {
                                    Context rootContext = config.serverInstance.createContext(0);
                                    rootContext.setPath("");
                                    rootContext.setDocBase(deployDir.append("ROOT").toOSString());
                                    rootContext.setReloadable("false");
                                    config.isServerDirty = true;
                                }
                                monitor.worked(100);
                                if (monitor.isCanceled()) {
                                    iStatus = Status.CANCEL_STATUS;
                                    break block23;
                                }
                                config.save(confDir, false, ProgressUtil.getSubMonitorFor(monitor, 30));
                                monitor.worked(100);
                                break block24;
                            }
                            catch (Exception e) {
                                Trace.trace((byte)2, "Error localizing configuration", e);
                                Status status = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
                                Object var19_15 = null;
                                monitor.done();
                                return status;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var19_16 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return iStatus2;
                }
                Object var19_13 = null;
                monitor.done();
                return multiStatus;
            }
            Object var19_14 = null;
            monitor.done();
            return iStatus;
        }
        Object var19_17 = null;
        monitor.done();
        return Status.OK_STATUS;
    }

    public void modifyMimeMapping(int index, IMimeMapping map) {
        this.webAppDocument.modifyMimeMapping(index, map);
        this.firePropertyChangeEvent("modifyMapping", new Integer(index), map);
    }

    public void modifyServerPort(String id, int port) {
        try {
            int con = Integer.parseInt(id);
            Connector connector = this.serverInstance.getConnector(con);
            int size = connector.getParameterCount();
            int i = 0;
            while (i < size) {
                Parameter p = connector.getParameter(i);
                if ("port".equals(p.getName())) {
                    p.setValue(String.valueOf(port));
                    this.isServerDirty = true;
                    this.firePropertyChangeEvent("modifyPort", id, new Integer(port));
                    return;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error modifying server port " + id, e);
        }
    }

    public void modifyWebModule(int index, String docBase, String path, boolean reloadable) {
        try {
            Context context = this.serverInstance.getContext(index);
            context.setPath(path);
            context.setDocBase(docBase);
            context.setReloadable(reloadable ? "true" : "false");
            this.isServerDirty = true;
            WebModule module = new WebModule(path, docBase, null, reloadable);
            this.firePropertyChangeEvent("modifyWebModule", new Integer(index), module);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error modifying web module " + index, e);
        }
    }

    public void removeMimeMapping(int index) {
        this.webAppDocument.removeMimeMapping(index);
        this.firePropertyChangeEvent("removeMapping", null, new Integer(index));
    }

    public void removeWebModule(int index) {
        try {
            this.serverInstance.removeContext(index);
            this.isServerDirty = true;
            this.firePropertyChangeEvent("removeWebModule", null, new Integer(index));
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error removing web module " + index, e);
        }
    }

    protected IStatus cleanupServer(IPath confDir, IPath installDir, IProgressMonitor monitor) {
        MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, Messages.cleanupServerTask, null);
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask(Messages.cleanupServerTask, 200);
        try {
            monitor.subTask(Messages.detectingRemovedProjects);
            Factory factory = new Factory();
            factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server32");
            File serverFile = confDir.append("conf").append("server.xml").toFile();
            if (serverFile.exists()) {
                Server oldServer = (Server)factory.loadDocument(new FileInputStream(serverFile));
                ServerInstance oldInstance = new ServerInstance(oldServer);
                HashSet<String> oldPaths = new HashSet<String>();
                Context[] contexts = oldInstance.getContexts();
                if (contexts != null) {
                    int i = 0;
                    while (i < contexts.length) {
                        String source = contexts[i].getSource();
                        if (source != null && source.length() > 0) {
                            oldPaths.add(contexts[i].getPath());
                        }
                        ++i;
                    }
                }
                List modules = this.getWebModules();
                int size = modules.size();
                int i = 0;
                while (i < size) {
                    WebModule module = (WebModule)modules.get(i);
                    oldPaths.remove(module.getPath());
                    ++i;
                }
                monitor.worked(100);
                if (oldPaths.size() > 0) {
                    IProgressMonitor subMonitor = ProgressUtil.getSubMonitorFor(monitor, 100);
                    subMonitor.beginTask(Messages.deletingContextFilesTask, oldPaths.size() * 100);
                    Iterator iter = oldPaths.iterator();
                    while (iter.hasNext()) {
                        String oldPath = (String)iter.next();
                        Context ctx = oldInstance.getContext(oldPath);
                        IPath ctxWorkPath = oldInstance.getContextWorkDirectory(confDir, ctx);
                        if (confDir.isPrefixOf(ctxWorkPath)) {
                            File ctxWorkDir = ctxWorkPath.toFile();
                            if (ctxWorkDir.exists() && ctxWorkDir.isDirectory()) {
                                IStatus[] results = PublishUtil.deleteDirectory((File)ctxWorkDir, (IProgressMonitor)ProgressUtil.getSubMonitorFor(monitor, 100));
                                if (results.length <= 0) continue;
                                Trace.trace((byte)2, "Could not delete work directory " + ctxWorkDir.getPath() + " for removed context " + oldPath);
                                int i2 = 0;
                                while (i2 < results.length) {
                                    ms.add(results[i2]);
                                    ++i2;
                                }
                                continue;
                            }
                            monitor.worked(100);
                            continue;
                        }
                        monitor.worked(100);
                    }
                    subMonitor.done();
                } else {
                    monitor.worked(100);
                }
            } else {
                monitor.worked(200);
            }
            if (Trace.isTraceEnabled()) {
                Trace.trace((byte)4, "Server cleaned");
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not cleanup server at " + confDir.toOSString() + ": " + e.getMessage());
            ms.add((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCleanupServer, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
        monitor.done();
        return ms;
    }
}

