/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.wst.server.core.IModule;

public class Tomcat40Handler
implements ITomcatVersionHandler {
    public IStatus verifyInstallPath(IPath installPath) {
        return TomcatPlugin.verifyInstallPathWithFolderCheck(installPath, "org.eclipse.jst.server.tomcat.40");
    }

    public String getRuntimeClass() {
        return "org.apache.catalina.startup.Bootstrap";
    }

    public List getRuntimeClasspath(IPath installPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        IPath binPath = installPath.append("bin");
        if (binPath.toFile().exists()) {
            IPath path = binPath.append("bootstrap.jar");
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
        }
        return cp;
    }

    public String[] getRuntimeProgramArguments(IPath configPath, boolean debug, boolean starting) {
        ArrayList<String> list = new ArrayList<String>();
        if (debug) {
            list.add("-debug");
        }
        if (starting) {
            list.add("start");
        } else {
            list.add("stop");
        }
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public String[] getExcludedRuntimeProgramArguments(boolean debug, boolean starting) {
        if (!debug) {
            return new String[]{"-debug"};
        }
        return null;
    }

    public String[] getRuntimeVMArguments(IPath installPath, IPath configPath, IPath deployPath, boolean isTestEnv) {
        ArrayList<String> list = new ArrayList<String>();
        if (isTestEnv) {
            list.add("-Dcatalina.base=\"" + configPath.toOSString() + "\"");
        } else {
            list.add("-Dcatalina.base=\"" + installPath.toOSString() + "\"");
        }
        list.add("-Dcatalina.home=\"" + installPath.toOSString() + "\"");
        list.add("-Dwtp.deploy=\"" + deployPath.toOSString() + "\"");
        String endorsed = String.valueOf(installPath.append("bin").toOSString()) + installPath.append("common").append("lib").toOSString();
        list.add("-Djava.endorsed.dirs=\"" + endorsed + "\"");
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public String getRuntimePolicyFile(IPath configPath) {
        return configPath.append("conf").append("catalina.policy").toOSString();
    }

    public IStatus canAddModule(IModule module) {
        String version = module.getModuleType().getVersion();
        if ("2.2".equals(version) || "2.3".equals(version)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorSpec40, null);
    }

    public IPath getRuntimeBaseDirectory(TomcatServer server) {
        return TomcatVersionHelper.getStandardBaseDirectory(server);
    }

    public IStatus prepareRuntimeDirectory(IPath baseDir) {
        return TomcatVersionHelper.createCatalinaInstanceDirectory(baseDir);
    }

    public IStatus prepareDeployDirectory(IPath deployPath) {
        return TomcatVersionHelper.createDeploymentDirectory(deployPath, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\">\n<web-app>\n</web-app>");
    }

    public IStatus prepareForServingDirectly(IPath baseDir, TomcatServer server) {
        if (server.isServeModulesWithoutPublish()) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorNoPublishNotSupported, null);
        }
        return Status.OK_STATUS;
    }

    public String getSharedLoader(IPath baseDir) {
        return null;
    }

    public boolean supportsServeModulesWithoutPublish() {
        return false;
    }

    public boolean supportsDebugArgument() {
        return true;
    }

    public boolean supportsSeparateContextFiles() {
        return false;
    }
}

