/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfcore;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.PropertyResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.converter.HiddenTagConverter;
import org.eclipse.jst.pagedesigner.utils.PreviewUtil;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class LoadBundleTagConverter
extends HiddenTagConverter {
    private static Logger _log = PDPlugin.getLogger(LoadBundleTagConverter.class);

    public LoadBundleTagConverter(Element host, ILabelProvider labelProvider) {
        super(host, labelProvider);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convertRefresh(Object context) {
        void var8_11;
        IDOMModel model;
        Element hostEle = this.getHostElement();
        String varString = hostEle.getAttribute("var");
        String baseName = hostEle.getAttribute("basename");
        if (baseName == null || varString == null) {
            return;
        }
        baseName = String.valueOf(baseName.replace('.', '/')) + "." + "properties";
        IProject project = null;
        if (hostEle instanceof IDOMNode && (model = ((IDOMNode)hostEle).getModel()) != null) {
            project = StructuredModelUtil.getProjectFor((IStructuredModel)model);
        }
        if (project == null) {
            return;
        }
        String prop = new StringBuffer("webroot").append("/").append("WEB-INF").append("/").append("classes").append("/").append(baseName).toString();
        IResource res = project.findMember(prop);
        if (res == null && (res = project.findMember(prop = "src/" + baseName)) == null) {
            return;
        }
        InputStream inputStream = null;
        try {
            BufferedInputStream bufferedInputStream;
            PropertyResourceBundle bundle;
            File f = new File(res.getLocation().toString());
            FileInputStream fileInputStream = new FileInputStream(f);
            if (fileInputStream != null && (bundle = new PropertyResourceBundle(bufferedInputStream = new BufferedInputStream(fileInputStream))) != null) {
                if (PreviewUtil.BUNDLE_MAP == null) {
                    PreviewUtil.BUNDLE_MAP = new HashMap();
                } else {
                    PreviewUtil.BUNDLE_MAP.clear();
                }
                PreviewUtil.BUNDLE_MAP.put(varString, bundle);
                PreviewUtil.BUNDLE = bundle;
                PreviewUtil.VAR = varString;
            }
        }
        catch (MalformedURLException e) {
            _log.error("LoadBundleTagConverter.convertRefresh.MalformedURLException", (Throwable)e);
            return;
        }
        catch (IOException e) {
            try {
                _log.error("LoadBundleTagConverter.convertRefresh.IOException", (Throwable)e);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ResourceUtils.ensureClosed(inputStream);
            }
        }
        ResourceUtils.ensureClosed((InputStream)var8_11);
    }
}

