/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.operations.jsf;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.TransformOperationFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTableOperation
extends AbstractTransformOperation {
    public Element transform(Element srcElement, Element curElement) {
        Element tableElement = null;
        tableElement = this.createElement("table");
        ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation("CopyAllAttributesOperation", new String[0]);
        operation.transform(srcElement, tableElement);
        operation = TransformOperationFactory.getInstance().getTransformOperation("RenameAttributeOperation", new String[]{"styleClass", "class"});
        operation.transform(srcElement, tableElement);
        this.buildHeaderOrFooter(srcElement, tableElement, true);
        this.buildBody(srcElement, tableElement);
        this.buildHeaderOrFooter(srcElement, tableElement, false);
        return tableElement;
    }

    private void buildHeaderOrFooter(Element srcElement, Element tableElement, boolean isHeader) {
        Element trElement;
        String facetName = isHeader ? "header" : "footer";
        String headerOrFooterTagName = isHeader ? "thead" : "tfoot";
        String thOrTdTagName = isHeader ? "th" : "td";
        String headerClassOrFooterClassAttrName = isHeader ? "headerClass" : "footerClass";
        Element facetElement = this.getChildFacetByName(srcElement, facetName);
        List columnElementList = this.getChildElements(srcElement, "column");
        boolean hasColumnFacet = false;
        for (Element columnElement : columnElementList) {
            Element columnFacet = this.getChildFacetByName(columnElement, facetName);
            if (columnFacet == null) continue;
            hasColumnFacet = true;
            break;
        }
        if (facetElement == null && !hasColumnFacet) {
            return;
        }
        Element headerOrFooterElement = this.appendChildElement(headerOrFooterTagName, tableElement);
        if (facetElement != null) {
            ITransformOperation operation;
            trElement = this.appendChildElement("tr", headerOrFooterElement);
            Element thOrTdElement = this.appendChildElement(thOrTdTagName, trElement);
            String headerClassOrFooterClassAttribute = srcElement.getAttribute(headerClassOrFooterClassAttrName);
            if (headerClassOrFooterClassAttribute != null && headerClassOrFooterClassAttribute.length() > 0) {
                operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"class", headerClassOrFooterClassAttribute});
                operation.transform(srcElement, thOrTdElement);
            }
            if (columnElementList.size() > 0) {
                operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"colspan", String.valueOf(columnElementList.size())});
                operation.transform(srcElement, thOrTdElement);
            }
            this.tagConverterContext.addChild((Node)facetElement, new ConvertPosition((Node)thOrTdElement, 0));
        }
        if (hasColumnFacet) {
            trElement = this.appendChildElement("tr", headerOrFooterElement);
            for (Element columnElement : columnElementList) {
                Element columnFacet = this.getChildFacetByName(columnElement, facetName);
                Element thOrTdElement = this.appendChildElement(thOrTdTagName, trElement);
                String headerClassOrFooterClassAttribute = srcElement.getAttribute(headerClassOrFooterClassAttrName);
                if (headerClassOrFooterClassAttribute != null && headerClassOrFooterClassAttribute.length() > 0) {
                    ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"class", headerClassOrFooterClassAttribute});
                    operation.transform(srcElement, thOrTdElement);
                }
                if (columnFacet == null) continue;
                this.tagConverterContext.addChild((Node)columnFacet, new ConvertPosition((Node)thOrTdElement, 0));
            }
        }
    }

    private void buildBody(Element srcElement, Element tableElement) {
        StringTokenizer tokenizer;
        Element tbodyElement = this.appendChildElement("tbody", tableElement);
        Element trElement = this.appendChildElement("tr", tbodyElement);
        String rowClassesAttribute = srcElement.getAttribute("rowClasses");
        if (rowClassesAttribute != null && rowClassesAttribute.length() > 0 && (tokenizer = new StringTokenizer(rowClassesAttribute, ", ")).hasMoreTokens()) {
            ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"class", tokenizer.nextToken()});
            operation.transform(srcElement, trElement);
        }
        List columnElementList = this.getChildElements(srcElement, "column");
        Iterator itColumnElementList = columnElementList.iterator();
        int index = 0;
        while (itColumnElementList.hasNext()) {
            Element columnElement = (Element)itColumnElementList.next();
            this.tagConverterContext.addChild((Node)columnElement, new ConvertPosition((Node)trElement, index++));
        }
    }

    private Element getChildFacetByName(Element srcElement, String facetName) {
        Element element = null;
        List facets = this.getChildElements(srcElement, "facet");
        for (Element facet : facets) {
            if (!facet.getAttribute("name").equals(facetName)) continue;
            element = facet;
            break;
        }
        return element;
    }
}

