/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.sections;

import java.util.HashMap;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StyleComboDialogField;
import org.eclipse.jst.pagedesigner.commands.single.ChangeAttributeCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.sections.SectionResources;
import org.eclipse.jst.pagedesigner.meta.EditorCreator;
import org.eclipse.jst.pagedesigner.meta.IAttributeDescriptor;
import org.eclipse.jst.pagedesigner.properties.attrgroup.AttributeGroup;
import org.eclipse.jst.pagedesigner.ui.dialogfields.DialogFieldWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class JSFCoreConvertDateTimeGroup
extends AttributeGroup {
    private StyleComboDialogField _typeField;
    private StyleComboDialogField _dateStyleField;
    private StyleComboDialogField _timeStyleField;
    private StyleComboDialogField _patternField;
    private static final String[] TYPES = new String[]{"date", "time", "both"};
    private static final String[] DATESTYLES = new String[]{"default", "short", "medium", "long", "full", "custom"};
    private static final String[] TIMESTYLES = new String[]{"default", "short", "medium", "long", "full", "custom"};
    private static final String[] DATEPATTERNS = new String[]{"", "M/d/yy", "EEE, M/d/yy", "MM/dd/yyyy", "EEE, MM/dd/yyyy", "MMM d, yyyy", "EEE, MMM d, yyyy", "MMMM d, yyyy", "EEEE, MMMM d, yyyy", "MMMM yyyy"};
    private static final String[] TIMEPATTERNS = new String[]{"", "hh:mm", "hh:mm z", "HH:mm z", "HH:mm:ss z"};
    private static final String[] DATETIMEPATTERNS = new String[]{"", "M/d/yy hh:mm", "EEE, M/d/yy hh:mm", "MM/dd/yyyy HH:mm:ss z", "EEE, MM/dd/yyyy HH:mm:ss z", "MMM d, yyyy HH:mm z", "EEE, MMM d, yyyy HH:mm z", "MMMM d, yyyy HH:mm z", "EEEE, MMMM d, yyyy HH:mm z"};

    public JSFCoreConvertDateTimeGroup() {
        super("http://java.sun.com/jsf/core", "convertDateTime", new String[]{"type", "dateStyle", "timeStyle", "pattern"});
    }

    protected DialogField createDialogField(String uri, String tag, IAttributeDescriptor attr) {
        EditorCreator creator = EditorCreator.getInstance();
        if (attr.getAttributeName().equals("type")) {
            DialogFieldWrapper wrapper = (DialogFieldWrapper)creator.createDialogFieldWithWrapper(uri, tag, attr, null);
            this._typeField = (StyleComboDialogField)wrapper.getWrappedDialogField();
            return wrapper;
        }
        if (attr.getAttributeName().equals("dateStyle")) {
            DialogFieldWrapper wrapper = (DialogFieldWrapper)creator.createDialogFieldWithWrapper(uri, tag, attr, null);
            this._dateStyleField = (StyleComboDialogField)wrapper.getWrappedDialogField();
            this._dateStyleField.setItems(DATESTYLES);
            return wrapper;
        }
        if (attr.getAttributeName().equals("timeStyle")) {
            DialogFieldWrapper wrapper = (DialogFieldWrapper)creator.createDialogFieldWithWrapper(uri, tag, attr, null);
            this._timeStyleField = (StyleComboDialogField)wrapper.getWrappedDialogField();
            this._timeStyleField.setItems(TIMESTYLES);
            return wrapper;
        }
        if (attr.getAttributeName().equals("pattern")) {
            DialogFieldWrapper wrapper = (DialogFieldWrapper)creator.createDialogFieldWithWrapper(uri, tag, attr, null);
            this._patternField = (StyleComboDialogField)wrapper.getWrappedDialogField();
            return wrapper;
        }
        return null;
    }

    public IDialogFieldApplyListener getDialogFieldApplyListener(String uri, String tag, IAttributeDescriptor attr) {
        String attribute = attr.getAttributeName();
        if (attribute.equals("type") || attribute.equals("dateStyle") || attribute.equals("timeStyle")) {
            IDialogFieldApplyListener listener = new IDialogFieldApplyListener(){

                public void dialogFieldApplied(DialogField field) {
                    JSFCoreConvertDateTimeGroup.this.updatePatternItems();
                    JSFCoreConvertDateTimeGroup.this.updateFieldStatus();
                    JSFCoreConvertDateTimeGroup.this.updateFieldData();
                }
            };
            return listener;
        }
        if (attribute.equals("pattern")) {
            IDialogFieldApplyListener listener = new IDialogFieldApplyListener(){

                public void dialogFieldApplied(DialogField field) {
                    JSFCoreConvertDateTimeGroup.this.updateFieldStatus();
                    JSFCoreConvertDateTimeGroup.this.updateFieldData();
                }
            };
            return listener;
        }
        return null;
    }

    public void refreshData() {
        IDOMElement element = this.getElement();
        String type = element.getAttribute("type");
        this._typeField.setTextWithoutUpdate(type);
        String dateStyle = element.getAttribute("dateStyle");
        if (!this._dateStyleField.getText().equalsIgnoreCase(DATESTYLES[5])) {
            this._dateStyleField.setTextWithoutUpdate(dateStyle);
        }
        String timeStyle = element.getAttribute("timeStyle");
        if (!this._timeStyleField.getText().equalsIgnoreCase(TIMESTYLES[5])) {
            this._timeStyleField.setTextWithoutUpdate(timeStyle);
        }
        String pattern = element.getAttribute("pattern");
        this._patternField.setTextWithoutUpdate(pattern);
        this.updateFieldStatus();
    }

    private void updateFieldStatus() {
        String type = this._typeField.getText();
        String dateStyle = this._dateStyleField.getText();
        String timeStyle = this._timeStyleField.getText();
        if (type.equalsIgnoreCase(TYPES[0])) {
            this._dateStyleField.setEnabled(true);
            this._timeStyleField.setEnabled(false);
            if (dateStyle.equalsIgnoreCase(DATESTYLES[5])) {
                this._patternField.setEnabled(true);
            } else {
                this._patternField.setEnabled(false);
            }
        } else if (type.equalsIgnoreCase(TYPES[1])) {
            this._dateStyleField.setEnabled(false);
            this._timeStyleField.setEnabled(true);
            if (timeStyle.equalsIgnoreCase(TIMESTYLES[5])) {
                this._patternField.setEnabled(true);
            } else {
                this._patternField.setEnabled(false);
            }
        } else if (type.equalsIgnoreCase(TYPES[2])) {
            this._dateStyleField.setEnabled(true);
            this._timeStyleField.setEnabled(true);
            if (dateStyle.equalsIgnoreCase(DATESTYLES[5]) || timeStyle.equalsIgnoreCase(TIMESTYLES[5])) {
                this._patternField.setEnabled(true);
            } else {
                this._patternField.setEnabled(false);
            }
        }
    }

    private void updatePatternItems() {
        String type = this._typeField.getText();
        String dateStyle = this._dateStyleField.getText();
        String timeStyle = this._timeStyleField.getText();
        if (type.equalsIgnoreCase(TYPES[0]) && dateStyle.equalsIgnoreCase(DATESTYLES[5])) {
            this._patternField.getComboControl(null, null).removeAll();
            this._patternField.getComboControl(null, null).setItems(DATEPATTERNS);
        }
        if (type.equalsIgnoreCase(TYPES[1]) && timeStyle.equalsIgnoreCase(TIMESTYLES[5])) {
            this._patternField.getComboControl(null, null).removeAll();
            this._patternField.getComboControl(null, null).setItems(TIMEPATTERNS);
        }
        if (type.equalsIgnoreCase(TYPES[2]) && (dateStyle.equalsIgnoreCase(DATESTYLES[5]) || timeStyle.equalsIgnoreCase(TIMESTYLES[5]))) {
            this._patternField.getComboControl(null, null).removeAll();
            this._patternField.getComboControl(null, null).setItems(DATETIMEPATTERNS);
        }
    }

    private void updateFieldData() {
        String type = this._typeField.getText();
        String dateStyle = this._dateStyleField.getText();
        String timeStyle = this._timeStyleField.getText();
        String pattern = this._patternField.getText();
        if (!this._dateStyleField.isEnabled() || dateStyle.equalsIgnoreCase(DATESTYLES[5])) {
            dateStyle = "";
        }
        if (!this._timeStyleField.isEnabled() || timeStyle.equalsIgnoreCase(TIMESTYLES[5])) {
            timeStyle = "";
        }
        if (!this._patternField.isEnabled()) {
            pattern = "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", type);
        map.put("dateStyle", dateStyle);
        map.put("timeStyle", timeStyle);
        map.put("pattern", pattern);
        ChangeAttributeCommand c = new ChangeAttributeCommand(SectionResources.getString("JSFCoreConvertDateTimeSection.ChangeAttribute"), this.getElement(), map);
        c.execute();
    }
}

