/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.ejb.ui.internal.util.EJBUIMessages;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.IEjbClientProjectCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class EJBClientComponentCreationWizardPage
extends DataModelWizardPage
implements IEjbClientProjectCreationDataModelProperties {
    protected EJBJar selProject = null;
    private Label selectedProjectLabel;
    private Text selectedProjectName;
    private Label clientJarURILabel;
    private Text clientJarURI;
    protected int indent = 0;
    private Label projectNameLabel;
    protected Text projectNameText = null;
    private static final String MODULE_NAME_UI = J2EEUIMessages.getResourceString((String)"94");
    private static final int SIZING_TEXT_FIELD_WIDTH = 305;

    public EJBClientComponentCreationWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(EJBUIMessages.EJB_Client_Title);
        this.setDescription(EJBUIMessages.EJB_Client_Desc);
    }

    public EJBClientComponentCreationWizardPage(IDataModel model, String pageName, String title, ImageDescriptor titleImage) {
        super(model, pageName, title, titleImage);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        top.setData((Object)new GridData(1808));
        Composite composite = new Composite(top, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.setInfopopID("org.eclipse.jst.j2ee.ui.EJB_NEW_EJB_WIZARD_PAGE2");
        this.createProjectNameGroup(composite);
        this.createEJBComponentSection(composite);
        this.createClientJarURISection(composite);
        this.handleHasClientJar();
        Dialog.applyDialogFont((Control)parent);
        return top;
    }

    private void createProjectNameGroup(Composite parent) {
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText(MODULE_NAME_UI);
        GridData data = new GridData();
        this.projectNameLabel.setLayoutData((Object)data);
        this.projectNameText = new Text(parent, 2048);
        data = new GridData(768);
        data.widthHint = 305;
        this.projectNameText.setLayoutData((Object)data);
        new Label(parent, 0);
        this.synchHelper.synchText(this.projectNameText, "IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME", new Control[]{this.projectNameLabel});
        this.projectNameText.setFocus();
    }

    private void createEJBComponentSection(Composite parent) {
        this.selectedProjectLabel = new Label(parent, 0);
        this.selectedProjectLabel.setText(EJBUIMessages.EJB_Project);
        GridData data = new GridData();
        this.selectedProjectLabel.setLayoutData((Object)data);
        this.selectedProjectName = new Text(parent, 2048);
        data = new GridData(768);
        data.widthHint = 305;
        this.selectedProjectName.setLayoutData((Object)data);
        new Label(parent, 0);
        this.selectedProjectName.setEditable(false);
        this.synchHelper.synchText(this.selectedProjectName, "IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME", new Control[]{this.selectedProjectLabel});
    }

    private void handleHasClientJar() {
        String projectName = this.model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME");
        IProject project = ProjectUtilities.getProject((String)projectName);
        if (project.exists() && project.isAccessible()) {
            EJBArtifactEdit edit = null;
            try {
                edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)project);
                if (edit != null && edit.hasEJBClientJARProject()) {
                    this.enableAllSections(false);
                } else {
                    this.enableAllSections(true);
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
    }

    private void enableAllSections(boolean state) {
        this.projectNameText.setEnabled(state);
        this.projectNameLabel.setEnabled(state);
        this.selectedProjectLabel.setEnabled(state);
        this.selectedProjectName.setEnabled(state);
        this.clientJarURILabel.setEnabled(state);
        this.clientJarURI.setEnabled(state);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME", "IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME", "IEjbClientProjectCreationDataModelProperties.CLIENT_URI "};
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    protected void enter() {
        super.enter();
    }

    private void createClientJarURISection(Composite parent) {
        this.clientJarURILabel = new Label(parent, 0);
        this.clientJarURILabel.setText(String.valueOf(EJBUIMessages.Client_JAR_URI) + " ");
        GridData data = new GridData();
        this.clientJarURILabel.setLayoutData((Object)data);
        this.clientJarURI = new Text(parent, 2048);
        data = new GridData(768);
        data.widthHint = 305;
        this.clientJarURI.setLayoutData((Object)data);
        new Label(parent, 0);
        this.synchHelper.synchText(this.clientJarURI, "IEjbClientProjectCreationDataModelProperties.CLIENT_URI ", new Control[]{this.clientJarURILabel});
    }
}

