/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.style;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.javascript.core.internal.jsparser.lexer.ILexer;
import org.eclipse.wst.javascript.core.internal.jsparser.lexer.LexerException;
import org.eclipse.wst.javascript.core.internal.jsparser.node.EOF;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TBlank;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TCommenttok;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TErrorChar;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TStringLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TUnterminatedComment;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TUnterminatedStringLiteral;
import org.eclipse.wst.javascript.ui.internal.common.JavaScriptColorPreferences;
import org.eclipse.wst.javascript.ui.internal.common.LexerCacheForJavaScript;
import org.eclipse.wst.javascript.ui.internal.common.Logger;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.provisional.style.Highlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class LineStyleProviderForJavaScript
implements LineStyleProvider,
IDocumentListener {
    private static HashSet boldKeywords = new HashSet();
    public static String[] keywords = null;
    private Hashtable htForNode2 = new Hashtable();
    private IStructuredDocument fDocument;
    private Highlighter fHighlighter;
    private PropertyChangeListener fPreferenceListener = new PropertyChangeListener();
    private boolean fIsInitialized = false;
    private nodedata ndDoc = null;

    static {
        keywords = new String[]{"continue", "return", "break", "throw", "else", "new", "var", "case", "finally", "void", "catch", "for", "switch", "while", "function", "this", "with", "default", "if", "delete", "in", "try", "do", "instanceof", "typeof", "null", "true", "false", "{", "}"};
        int i = 0;
        while (i < keywords.length) {
            boldKeywords.add(keywords[i]);
            ++i;
        }
    }

    void handlePropertyChange(PropertyChangeEvent event) {
        Enumeration values = this.htForNode2.elements();
        while (values.hasMoreElements()) {
            nodedata nd = (nodedata)values.nextElement();
            nd.cachedStyles.clear();
        }
        this.fHighlighter.refreshDisplay();
    }

    public void init(IStructuredDocument structuredDocument, Highlighter highlighter) {
        IStructuredDocument currentDocument = this.fDocument;
        if (currentDocument != null && currentDocument != structuredDocument) {
            currentDocument.removeDocumentListener((IDocumentListener)this);
        }
        this.fDocument = structuredDocument;
        this.fDocument.addDocumentListener((IDocumentListener)this);
        this.fHighlighter = highlighter;
        if (this.fIsInitialized) {
            return;
        }
        JavaScriptColorPreferences.addPropertyChangeListener(this.fPreferenceListener);
        this.fIsInitialized = true;
    }

    private nodedata getNodeData(IStructuredDocumentRegion fnode) {
        if (fnode == null) {
            if (this.ndDoc == null) {
                this.ndDoc = new nodedata();
            }
            return this.ndDoc;
        }
        nodedata nd = (nodedata)this.htForNode2.get(fnode);
        if (nd == null) {
            nd = new nodedata();
            this.htForNode2.put(fnode, nd);
        }
        return nd;
    }

    protected ILexer getParseStartPoint(IStructuredDocumentRegion fnode, ITextRegion region, int offStart, boolean startHere) {
        int iNodeOffset = 0;
        if (fnode != null) {
            iNodeOffset = fnode.getStartOffset();
        }
        nodedata nd = this.getNodeData(fnode);
        if (nd.pcParseCache == null) {
            if (fnode != null) {
                nd.strOldNodeValue = fnode.getText();
                nd.pcParseCache = LexerCacheForJavaScript.getCache(fnode, nd.strOldNodeValue);
                nd.pcParseCache.notifyChange(nd.strOldNodeValue, -1, 0, 0);
            } else {
                nd.pcParseCache = LexerCacheForJavaScript.getCache(fnode, nd.strOldNodeValue == null ? "" : nd.strOldNodeValue);
            }
        }
        return nd.pcParseCache.getParser(offStart - iNodeOffset, startHere);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        Enumeration keys = this.htForNode2.keys();
        while (keys.hasMoreElements()) {
            IStructuredDocumentRegion fnode = (IStructuredDocumentRegion)keys.nextElement();
            int idxNodeStart = fnode.getStart();
            int idxNodeEnd = fnode.getEnd();
            int idxChgEnd = event.fOffset + event.fLength;
            if (event.fOffset <= idxNodeStart && idxChgEnd >= idxNodeEnd) {
                LexerCacheForJavaScript.release(fnode);
                this.htForNode2.remove(fnode);
                continue;
            }
            if (event.fOffset >= idxNodeEnd || idxChgEnd <= idxNodeStart) continue;
            this.nodeChanged(fnode, event.fOffset - idxNodeStart, event.fLength, event.fText);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nodeChanged(IStructuredDocumentRegion fnode, int idxInsertPos, int iReplacedLen, String strInserted) {
        nodedata nd = this.getNodeData(fnode);
        try {
            if (fnode != null) {
                LexerCacheForJavaScript lx = LexerCacheForJavaScript.getCache(fnode, "");
                if (nd.pcParseCache != null && nd.pcParseCache != lx) {
                    Logger.log(202, "Unreliable way to find the node, and memory leak (hopefully small) will result, unless only showing part of editor (then everything is fine)");
                }
                nd.pcParseCache = lx;
            }
            if (strInserted == null) return;
            String nv = null;
            nv = String.valueOf(nd.strOldNodeValue.substring(0, idxInsertPos)) + strInserted + nd.strOldNodeValue.substring(idxInsertPos + iReplacedLen);
            if (nv == null) return;
            if (nd.strOldNodeValue == null) {
                nd.pcParseCache.notifyChange(nv, 0, 0, nv.length());
                nd.cachedStyles.clear();
            } else {
                int idx = 0;
                idx = idxInsertPos;
                if ((idx -= 2) < 0) {
                    idx = 0;
                }
                nd.pcParseCache.notifyChange(nv, idx, nd.strOldNodeValue.length() - idx, nv.length() - idx);
                if (nd.cachedStyles.size() > 0) {
                    int csize = nd.cachedStyles.size();
                    int offIdx = idx + nd.offCachedStylesRegion;
                    StyleRange srOne = (StyleRange)nd.cachedStyles.get(0);
                    if (srOne.start > offIdx) {
                        nd.cachedStyles.clear();
                    } else {
                        while (csize-- > 0) {
                            srOne = (StyleRange)nd.cachedStyles.get(csize);
                            if (srOne.start + srOne.length < offIdx) break;
                            nd.cachedStyles.remove(srOne);
                        }
                    }
                }
            }
            nd.strOldNodeValue = nv;
            return;
        }
        catch (Exception exc) {
            Logger.log(202, "Exception in notifyChanged() of LineStyleProviderForJavaScript", exc);
        }
    }

    public boolean prepareRegions(ITypedRegion currentRegion, int offStart, int length, Collection holdResults) {
        IStructuredDocument structuredDocument = this.fDocument;
        IStructuredDocumentRegion fnode = structuredDocument.getRegionAtCharacterOffset(offStart);
        Vector vecTempResults = new Vector();
        int offStart2 = offStart;
        int length2 = length;
        if (offStart2 < currentRegion.getOffset()) {
            int diff = currentRegion.getOffset() - offStart2;
            offStart2 += diff;
            length2 -= diff;
        }
        if (offStart2 + length2 - 1 > this.getEndOffset(currentRegion)) {
            length2 = this.getEndOffset(currentRegion) - offStart2 + 1;
        }
        boolean retval = this.prepareRegions2(fnode, currentRegion, offStart2, length2, vecTempResults);
        int veclen = vecTempResults.size();
        int i = 0;
        while (i < veclen) {
            holdResults.add(LineStyleProviderForJavaScript.returnPrunedStyle(offStart2, length2, (StyleRange)vecTempResults.get(i)));
            ++i;
        }
        return retval;
    }

    private int getEndOffset(ITypedRegion currentRegion) {
        return currentRegion.getOffset() + currentRegion.getLength() - 1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean prepareRegions2(IStructuredDocumentRegion fnode, ITypedRegion currentRegion, int offStart, int length, Collection holdResults) {
        block43: {
            if (offStart > this.getEndOffset(currentRegion)) {
                return false;
            }
            if (offStart + length <= currentRegion.getOffset()) {
                return false;
            }
            startHere = false;
            offMax = offStart + length;
            offStart2 = offStart;
            previousAttr = null;
            offNode = 0;
            if (this.fDocument != null && fnode != null) {
                offNode = fnode.getStartOffset();
            }
            nd = this.getNodeData(fnode);
            try {
                block45: {
                    block44: {
                        cacheSize = nd.cachedStyles.size();
                        if (cacheSize <= 0) break block44;
                        if (nd.offCachedStylesRegion != offNode) {
                            delta = offNode - nd.offCachedStylesRegion;
                            sidx = 0;
                            while (sidx < cacheSize) {
                                sr = (StyleRange)nd.cachedStyles.get(sidx);
                                sr.start += delta;
                                ++sidx;
                            }
                        }
                        nd.offCachedStylesRegion = offNode;
                        srLastCached = (StyleRange)nd.cachedStyles.get(cacheSize - 1);
                        if (((StyleRange)nd.cachedStyles.get((int)0)).start <= offStart && offStart < srLastCached.start + srLastCached.length) break block45;
                        if (cacheSize > 150 || ((StyleRange)nd.cachedStyles.get((int)0)).start > offStart) {
                            nd.cachedStyles.clear();
                        } else if (srLastCached.start + srLastCached.length + 2 < offStart) {
                            nd.cachedStyles.clear();
                        } else {
                            offStart2 = srLastCached.start + srLastCached.length;
                            startHere = true;
                        }
                    }
lbl36:
                    // 2 sources

                    while (true) {
                        styleRange = null;
                        offsReq = offStart2 - offNode;
                        offsMax = offMax - offNode;
                        lexer2 = this.getParseStartPoint(fnode, null, offStart2, startHere);
                        if (lexer2 == null) {
                            return true;
                        }
                        tkThis = lexer2.next();
                        do {
                            if (tkThis.getLPOffset() >= offsMax + 200) {
                                return true;
                            }
                            strTkThis = tkThis.toString();
                            offsTkThis = tkThis.getLPOffset();
                            offsTkThisEnd = offsTkThis + strTkThis.length();
                            attr = null;
                            if (offsTkThisEnd <= offsReq) continue;
                            attr = JavaScriptColorPreferences.taDefault;
                            if (tkThis instanceof TStringLiteral) {
                                attr = JavaScriptColorPreferences.taStringLit;
                            } else if (tkThis instanceof TBlank) {
                                if (styleRange != null && (styleRange.background == attr.getBackground() || styleRange.background != null && attr.getBackground() != null && styleRange.background.equals((Object)attr.getBackground())) && attr.getStyle() == styleRange.fontStyle) {
                                    attr = previousAttr;
                                }
                            } else if (tkThis instanceof TCommenttok) {
                                attr = JavaScriptColorPreferences.taComment;
                            } else if (tkThis instanceof TUnterminatedComment) {
                                attr = JavaScriptColorPreferences.taUnfComment;
                            } else if (tkThis instanceof TUnterminatedStringLiteral) {
                                attr = JavaScriptColorPreferences.taUnfComment;
                            } else if (tkThis instanceof TErrorChar) {
                                attr = JavaScriptColorPreferences.taUnfComment;
                            } else if (LineStyleProviderForJavaScript.boldKeywords.contains(strTkThis)) {
                                attr = JavaScriptColorPreferences.taKeyword;
                            }
                            if (styleRange != null && previousAttr != null && previousAttr.equals((Object)attr)) {
                                styleRange.length += strTkThis.length();
                                continue;
                            }
                            styleRange = new StyleRange(offNode + offsTkThis, strTkThis.length(), attr.getForeground(), attr.getBackground(), attr.getStyle());
                            if ((attr.getStyle() & 0x20000000) != 0) {
                                styleRange.strikeout = true;
                            }
                            if ((attr.getStyle() & 0x40000000) != 0) {
                                styleRange.underline = true;
                            }
                            if (offsTkThis < offsMax) {
                                holdResults.add(styleRange);
                            }
                            nd.cachedStyles.add(styleRange);
                            previousAttr = attr;
                        } while (!((tkThis = lexer2.next()) instanceof EOF));
                        return true;
                    }
                }
                ii = 0;
                srOne = null;
                iihigh = cacheSize - 1;
                iilow = 0;
                break block43;
            }
            catch (IOException exc) {
                Logger.log(202, "Exception in JavaScript prepareRegions()", exc);
                return true;
            }
            catch (LexerException exc) {
                Logger.log(202, "Exception in JavaScript prepareRegions()", exc);
                return true;
            }
            catch (Exception exc) {
                Logger.log(202, "Exception in JavaScript prepareRegions()", exc);
            }
            return true;
        }
        while (true) {
            ii = (iihigh + iilow) / 2;
            srOne = (StyleRange)nd.cachedStyles.get(ii);
            if (srOne.start > offStart) {
                if (iihigh == ii) {
                    return false;
                }
                iihigh = ii;
                continue;
            }
            if (srOne.start + srOne.length > offStart) ** GOTO lbl121
            iilow = ii + 1;
        }
lbl-1000:
        // 1 sources

        {
            holdResults.add(LineStyleProviderForJavaScript.returnPrunedStyle(offStart, length, srOne));
            if (++ii >= cacheSize) break;
            srOne = (StyleRange)nd.cachedStyles.get(ii);
lbl121:
            // 2 sources

            ** while (srOne.start < offMax)
        }
lbl122:
        // 2 sources

        if (srOne.start + srOne.length >= offMax) {
            return true;
        }
        offStart2 = srOne.start + srOne.length;
        if (cacheSize > 150) {
            nd.cachedStyles.clear();
        }
        startHere = true;
        ** while (true)
    }

    public static StyleRange returnPrunedStyle(int offRegStart, int lenReg, StyleRange srIn) {
        int intSRStart = srIn.start;
        int intSREnd = srIn.start + srIn.length;
        if (intSRStart < offRegStart) {
            intSRStart = offRegStart;
        }
        if (intSREnd > offRegStart + lenReg) {
            intSREnd = offRegStart + lenReg;
        }
        if (intSRStart == srIn.start && intSREnd == srIn.start + srIn.length) {
            return (StyleRange)srIn.clone();
        }
        StyleRange retval = (StyleRange)srIn.clone();
        retval.start = intSRStart;
        retval.length = intSREnd - intSRStart;
        return retval;
    }

    public static StyleRange returnPrunedStyleWithEndDup(int offRegStart, int lenReg, StyleRange srIn) {
        StyleRange sr2 = LineStyleProviderForJavaScript.returnPrunedStyle(offRegStart, lenReg, srIn);
        int intSREnd = srIn.start + srIn.length;
        if (srIn == sr2 && intSREnd == offRegStart + lenReg) {
            return (StyleRange)sr2.clone();
        }
        return sr2;
    }

    public void release() {
        this.releaseNodesInLexerCache();
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener((IDocumentListener)this);
        }
        JavaScriptColorPreferences.removePropertyChangeListener(this.fPreferenceListener);
        this.fIsInitialized = false;
    }

    protected void releaseNodesInLexerCache() {
        Enumeration keys = this.htForNode2.keys();
        while (keys.hasMoreElements()) {
            IStructuredDocumentRegion fnode = (IStructuredDocumentRegion)keys.nextElement();
            LexerCacheForJavaScript.release(fnode);
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            LineStyleProviderForJavaScript.this.handlePropertyChange(event);
        }
    }

    class nodedata {
        protected LexerCacheForJavaScript pcParseCache = null;
        protected ArrayList cachedStyles = new ArrayList(100);
        protected int offCachedStylesRegion = 0;
        protected String strOldNodeValue = null;

        nodedata() {
        }
    }
}

