/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDynamicPreset;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.util.IndexedSet;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.internal.AbstractDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.ChangeTargetedRuntimesDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModifyFacetedProjectDataModel
extends AbstractDataModel {
    public static String EVENT_FIXED_FACETS_CHANGED = "fixedFacetsChanged";
    public static String EVENT_AVAILABLE_FACETS_CHANGED = "availableFacetsChanged";
    public static String EVENT_AVAILABLE_PRESETS_CHANGED = "availablePresetsChanged";
    public static String EVENT_SELECTED_PRESET_CHANGED = "selectedPresetChanged";
    private final IFacetedProject project;
    private Set<IProjectFacet> fixedFacets;
    private Map<IProjectFacet, Set<IProjectFacetVersion>> availableFacets;
    private IndexedSet<String, IPreset> availablePresets;
    private IPreset selectedPreset;
    private final ChangeTargetedRuntimesDataModel runtimesDataModel;

    public ModifyFacetedProjectDataModel(IFacetedProject project) {
        this.project = project;
        this.fixedFacets = Collections.emptySet();
        this.availableFacets = Collections.emptyMap();
        this.availablePresets = new IndexedSet();
        this.selectedPreset = null;
        this.runtimesDataModel = new ChangeTargetedRuntimesDataModel();
        this.refreshAvailableFacets();
        AbstractDataModel.IDataModelListener avFacetsListener = new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                ModifyFacetedProjectDataModel.this.refreshAvailableFacets();
            }
        };
        this.addListener(EVENT_FIXED_FACETS_CHANGED, avFacetsListener);
        this.runtimesDataModel.addListener("targetedRuntimesChanged", avFacetsListener);
        this.refreshAvailablePresets();
        AbstractDataModel.IDataModelListener avPresetsListener = new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                ModifyFacetedProjectDataModel.this.refreshAvailablePresets();
            }
        };
        this.addListener(EVENT_FIXED_FACETS_CHANGED, avPresetsListener);
        this.addListener(EVENT_AVAILABLE_FACETS_CHANGED, avPresetsListener);
        this.runtimesDataModel.addListener("primaryRuntimeChanged", avPresetsListener);
    }

    public IFacetedProject getFacetedProject() {
        return this.project;
    }

    public synchronized Set<IProjectFacet> getFixedFacets() {
        return this.fixedFacets;
    }

    public synchronized void setFixedFacets(Set<IProjectFacet> fixed) {
        if (this.fixedFacets.equals(fixed)) {
            return;
        }
        this.fixedFacets = Collections.unmodifiableSet(new HashSet<IProjectFacet>(fixed));
        this.notifyListeners(EVENT_FIXED_FACETS_CHANGED);
    }

    public synchronized Map<IProjectFacet, Set<IProjectFacetVersion>> getAvailableFacets() {
        return this.availableFacets;
    }

    public synchronized boolean isFacetAvailable(IProjectFacet f) {
        return this.availableFacets.containsKey(f);
    }

    public synchronized boolean isFacetAvailable(IProjectFacetVersion fv) {
        Set<IProjectFacetVersion> versions = this.availableFacets.get(fv.getProjectFacet());
        return versions != null && versions.contains(fv);
    }

    private synchronized void refreshAvailableFacets() {
        HashMap newAvailableFacets = new HashMap();
        Set<IRuntime> targetedRuntimes = this.runtimesDataModel.getTargetedRuntimes();
        for (IProjectFacet f : ProjectFacetsManager.getProjectFacets()) {
            HashSet<IProjectFacetVersion> versions = null;
            for (IProjectFacetVersion fv : f.getVersions()) {
                boolean available = true;
                if (this.project == null || !this.project.hasProjectFacet(fv)) {
                    for (IRuntime r : targetedRuntimes) {
                        if (r.supports(fv)) continue;
                        available = false;
                        break;
                    }
                    if (available && !fv.isValidFor(this.fixedFacets)) {
                        available = false;
                    }
                }
                if (!available) continue;
                if (versions == null) {
                    versions = new HashSet<IProjectFacetVersion>();
                }
                versions.add(fv);
            }
            if (versions == null) continue;
            newAvailableFacets.put(f, Collections.unmodifiableSet(versions));
        }
        if (!this.availableFacets.equals(newAvailableFacets)) {
            this.availableFacets = Collections.unmodifiableMap(newAvailableFacets);
            this.notifyListeners(EVENT_AVAILABLE_FACETS_CHANGED);
        }
    }

    public synchronized Set<IPreset> getAvailablePresets() {
        return this.availablePresets.getUnmodifiable();
    }

    public synchronized void refreshAvailablePresets() {
        IndexedSet newAvailablePresets = new IndexedSet();
        HashMap<String, Set<Object>> context = null;
        for (IPreset preset : ProjectFacetsManager.getPresets()) {
            if (preset.getType() == IPreset.Type.DYNAMIC) {
                if (context == null) {
                    context = new HashMap<String, Set<Object>>();
                    context.put("CONTEXT_KEY_FIXED_FACETS", this.fixedFacets);
                    context.put("CONTEXT_KEY_PRIMARY_RUNTIME", (Set<Object>)this.runtimesDataModel.getPrimaryRuntime());
                }
                if ((preset = ((IDynamicPreset)preset).resolve(context)) == null) continue;
            }
            Set facets = preset.getProjectFacets();
            boolean applicable = true;
            for (IProjectFacetVersion fv : facets) {
                if (this.isFacetAvailable(fv)) continue;
                applicable = false;
                break;
            }
            for (IProjectFacet f : this.fixedFacets) {
                boolean found = false;
                for (IProjectFacetVersion fv : f.getVersions()) {
                    if (!facets.contains(fv)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                applicable = false;
                break;
            }
            if (!applicable) continue;
            newAvailablePresets.add((Object)preset.getId(), (Object)preset);
        }
        if (!this.availablePresets.equals((Object)newAvailablePresets)) {
            this.availablePresets = newAvailablePresets;
            this.notifyListeners(EVENT_AVAILABLE_PRESETS_CHANGED);
            if (this.selectedPreset != null && !this.availablePresets.contains((Object)this.selectedPreset)) {
                this.setSelectedPreset(null);
            }
        }
    }

    public synchronized IPreset getSelectedPreset() {
        return this.selectedPreset;
    }

    public synchronized void setSelectedPreset(String presetId) {
        if (presetId != null && !this.availablePresets.containsKey((Object)presetId)) {
            String msg = Resources.bind((String)Resources.couldNotSelectPreset, (Object)presetId);
            throw new IllegalArgumentException(msg);
        }
        IPreset preset = (IPreset)this.availablePresets.get((Object)presetId);
        if (!ModifyFacetedProjectDataModel.equals(this.selectedPreset, preset)) {
            this.selectedPreset = preset;
            this.notifyListeners(EVENT_SELECTED_PRESET_CHANGED);
        }
    }

    public ChangeTargetedRuntimesDataModel getTargetedRuntimesDataModel() {
        return this.runtimesDataModel;
    }

    public void dispose() {
        this.runtimesDataModel.dispose();
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private static final class Resources
    extends NLS {
        public static String couldNotSelectPreset;

        static {
            Resources.initializeMessages((String)ModifyFacetedProjectDataModel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

