/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.webservice.wsclient.Handler;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerServiceRefHolder;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.AbstractHandlersWidgetDefaultingCmd;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;

public class ClientHandlersWidgetDefaultingCommand
extends AbstractHandlersWidgetDefaultingCmd {
    private WebServicesManager webServicesManager_;
    private IProject project_;
    private String serviceRefName_ = null;
    private List wsServiceRefs_;
    private HandlerServiceRefHolder[] handlerServiceRefHolder_;
    private String errorStatusMsg_ = null;
    private boolean isMultipleSelection_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        this.webServicesManager_ = WebServicesManager.getInstance();
        IStructuredSelection selection = this.getInitialSelection();
        if (selection == null) {
            status = StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED);
            env.getStatusHandler().reportError(status);
            return status;
        }
        if (selection.size() > 1) {
            status = this.processMultipleHandlers();
            return status;
        }
        status = this.processHandlers();
        return status;
    }

    public IStatus processHandlers() {
        try {
            Collection selectedServiceRefs = this.getWSServiceRefsFromSelection();
            if (selectedServiceRefs == null || selectedServiceRefs.isEmpty()) {
                return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_WEB_SERVICE_CLIENTS_NOT_FOUND);
            }
            this.wsServiceRefs_ = this.webServicesManager_.getAllWorkspaceServiceRefs();
            if (this.wsServiceRefs_ != null) {
                int numberOfServiceRefs = this.wsServiceRefs_.size();
                this.handlerServiceRefHolder_ = new HandlerServiceRefHolder[numberOfServiceRefs];
                int i = 0;
                while (i < numberOfServiceRefs) {
                    ServiceRef wsServiceRef = (ServiceRef)this.wsServiceRefs_.get(i);
                    Vector<HandlerTableItem> handlers = new Vector<HandlerTableItem>();
                    EList wsHandlers = wsServiceRef.getHandlers();
                    int k = 0;
                    while (k < wsHandlers.size()) {
                        Handler wsHandler = (Handler)wsHandlers.get(k);
                        HandlerTableItem handlerItem = new HandlerTableItem();
                        handlerItem.setHandler(wsHandler);
                        handlerItem.setHandlerName(wsHandler.getHandlerName());
                        handlerItem.setHandlerClassName(wsHandler.getHandlerClass().getQualifiedName());
                        handlerItem.setWsDescRef(wsServiceRef);
                        handlers.add(handlerItem);
                        ++k;
                    }
                    String wsServiceRefName = wsServiceRef.getServiceRefName();
                    this.handlerServiceRefHolder_[i] = new HandlerServiceRefHolder();
                    this.handlerServiceRefHolder_[i].setHandlerList(handlers);
                    this.handlerServiceRefHolder_[i].setServiceRef(wsServiceRef);
                    this.handlerServiceRefHolder_[i].setServiceRefName(wsServiceRefName);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IStatus processMultipleHandlers() {
        ServiceRef[] serviceRefs = this.getServiceRefs();
        if (this.errorStatusMsg_ != null) {
            return StatusUtils.errorStatus((String)this.errorStatusMsg_);
        }
        this.isMultipleSelection_ = true;
        this.handlerServiceRefHolder_ = new HandlerServiceRefHolder[serviceRefs.length];
        Vector handlers = new Vector();
        int i = 0;
        while (i < serviceRefs.length) {
            String refName = serviceRefs[i].getServiceRefName();
            this.handlerServiceRefHolder_[i] = new HandlerServiceRefHolder();
            this.handlerServiceRefHolder_[i].setHandlerList(handlers);
            this.handlerServiceRefHolder_[i].setServiceRefName(refName);
            this.handlerServiceRefHolder_[i].setServiceRef(serviceRefs[i]);
            ++i;
        }
        return Status.OK_STATUS;
    }

    public boolean getGenSkeletonEnabled() {
        return !this.isMultipleSelection_;
    }

    public String getServiceRefName() {
        return this.serviceRefName_;
    }

    public IProject getClientProject() {
        return this.project_;
    }

    private ServiceRef[] getServiceRefs() {
        IStructuredSelection initSel = this.getInitialSelection();
        ServiceRef[] serviceRefs = new ServiceRef[initSel.size()];
        Iterator iter = initSel.iterator();
        int i = 0;
        while (i < initSel.size()) {
            Object obj = iter.next();
            if (!(obj instanceof ServiceRef)) {
                this.errorStatusMsg_ = ConsumptionUIMessages.MSG_ERROR_INVALID_MULTIPLE_SERVICE_SELECT;
                return null;
            }
            serviceRefs[i] = (ServiceRef)obj;
            ++i;
        }
        return serviceRefs;
    }

    /*
     * Exception decompiling
     */
    private Collection getWSServiceRefsFromSelection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 464->470)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Collection getWsServiceRefs() {
        return this.wsServiceRefs_;
    }

    public boolean getIsMultipleSelection() {
        return this.isMultipleSelection_;
    }

    public HandlerServiceRefHolder[] getHandlerServiceRefHolder() {
        return this.handlerServiceRefHolder_;
    }
}

