/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class AbstractJSFFacetUninstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            this.removeJSFLibaries(project, monitor);
            this.uninstallJSFReferencesFromWebApp(project, monitor);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void removeJSFLibaries(IProject project, IProgressMonitor monitor) {
        IJavaProject jproj = JavaCore.create((IProject)project);
        ArrayList<IClasspathEntry> keptEntries = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] entries = jproj.getRawClasspath();
            keptEntries = new ArrayList();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 5 && !entry.getPath().segment(0).equals("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer")) {
                    keptEntries.add(entry);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Cannot get classpath entries to remove JSF Libraries for: " + project.getName());
        }
        if (keptEntries.size() > 0) {
            try {
                jproj.setRawClasspath(keptEntries.toArray(new IClasspathEntry[0]), monitor);
            }
            catch (JavaModelException e) {
                JSFCorePlugin.log((Exception)((Object)e), "Exception occured while removing JSF Libraries during JSF Facet uninstall");
            }
        }
    }

    protected abstract void uninstallJSFReferencesFromWebApp(IProject var1, IProgressMonitor var2);
}

