/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.internal.project.facet.AbstractJSFFacetUninstallDelegate;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils12;

public class JSFJavaEEFacetUninstallDelegate
extends AbstractJSFFacetUninstallDelegate {
    protected void uninstallJSFReferencesFromWebApp(IProject project, IProgressMonitor monitor) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object webAppObj = provider.getModelObject();
        if (webAppObj != null && JSFUtils12.isWebApp25(webAppObj)) {
            WebApp webApp = (WebApp)webAppObj;
            Servlet servlet = JSFUtils12.findJSFServlet(webApp);
            if (servlet == null) {
                return;
            }
            provider.modify((Runnable)new RemoveJSFFromWebAppOperation(webApp, servlet), new Path("WEB-INF").append("web.xml"));
        }
    }

    private void removeJSFContextParams(WebApp webApp, Servlet servlet) {
        for (ParamValue cp : webApp.getContextParams()) {
            if (!cp.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
            webApp.getContextParams().remove(cp);
            break;
        }
    }

    private void removeJSFServlet(WebApp webApp, Servlet servlet) {
        webApp.getServlets().remove(servlet);
    }

    class RemoveJSFFromWebAppOperation
    implements Runnable {
        private WebApp webApp;
        private Servlet servlet;

        RemoveJSFFromWebAppOperation(WebApp webApp, Servlet servlet) {
            this.webApp = webApp;
            this.servlet = servlet;
        }

        public void run() {
            JSFUtils12.removeURLMappings(this.webApp, this.servlet);
            JSFJavaEEFacetUninstallDelegate.this.removeJSFContextParams(this.webApp, this.servlet);
            JSFJavaEEFacetUninstallDelegate.this.removeJSFServlet(this.webApp, this.servlet);
        }
    }
}

