/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.FacesConfigIdentifierFeatures;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages;
import org.eclipse.osgi.util.NLS;

public class FacesConfigConverterIDFeatures
extends FacesConfigIdentifierFeatures {
    protected static final String CONVERTER = "javax.faces.convert.Converter";
    protected static final String IMAGE_NAME = "/icons/full/obj16/FacesConfig_Converter.gif";

    protected List getElements(JSFAppConfigManager mgr) {
        if (mgr != null) {
            return mgr.getConverters();
        }
        return new ArrayList(0);
    }

    protected String getReturnType() {
        return CONVERTER;
    }

    protected List getPossibleValueProposals(List elements) {
        ArrayList<PossibleValue> ret = new ArrayList<PossibleValue>();
        Collections.sort(elements, new ConverterSorter());
        for (ConverterType obj : elements) {
            PossibleValue pv;
            if (obj.getConverterId() == null || obj.getConverterId().getTextContent() == null || (pv = this.createProposal(obj.getConverterId().getTextContent(), obj.getDisplayName(), obj.getDescription())) == null) continue;
            pv.setIcon(this.getImage());
            ret.add(pv);
        }
        return ret;
    }

    protected String getImageName() {
        return IMAGE_NAME;
    }

    protected String getMyValidationMessage(String value) {
        if (value == null || value.trim().equals("")) {
            return Messages.FacesConfigConverterIDFeatures_converterid_empty;
        }
        return NLS.bind((String)Messages.FacesConfigIdentifierType_invalid_converter_id, (Object[])new String[]{this.singleQuote(value)});
    }

    protected List getElementIDs(JSFAppConfigManager mgr) {
        List elements = this.getElements(mgr);
        ArrayList<String> ret = new ArrayList<String>(elements.size());
        for (ConverterType aType : elements) {
            String id;
            if (aType.getConverterId() == null || aType.getConverterId().getTextContent() == null || (id = aType.getConverterId().getTextContent()) == null) continue;
            ret.add(id.trim());
        }
        return ret;
    }

    class ConverterSorter
    implements Comparator {
        ConverterSorter() {
        }

        public int compare(Object o1, Object o2) {
            return 0;
        }
    }
}

