/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class ProjectPropertyPage
extends PropertyPage {
    protected IProject project;
    protected IModule module;
    protected IServer server;
    protected Table table;
    protected int count;
    protected IServer defaultServer;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        try {
            IAdaptable element = this.getElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.project = (IProject)element.getAdapter((Class)clazz);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            layout.verticalSpacing = 5;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            this.module = ServerUtil.getModule((IProject)this.project);
            if (this.module == null) {
                Label label = new Label(composite, 0);
                label.setText(Messages.prefProjectNotModule);
                GridData data = new GridData(256);
                data.horizontalSpan = 2;
                data.verticalIndent = 5;
                label.setLayoutData((Object)data);
            } else {
                GridData data;
                Label label;
                IModuleType mt = this.module.getModuleType();
                if (mt != null) {
                    Label label2 = new Label(composite, 0);
                    label2.setText(Messages.prefProject);
                    GridData data2 = new GridData(256);
                    data2.verticalIndent = 5;
                    label2.setLayoutData((Object)data2);
                    Label moduleKind = new Label(composite, 0);
                    data2 = new GridData(256);
                    data2.verticalIndent = 5;
                    moduleKind.setLayoutData((Object)data2);
                    moduleKind.setText(String.valueOf(this.module.getName()) + " (" + mt.getName() + ")");
                }
                this.defaultServer = ServerCore.getDefaultServer((IModule)this.module);
                final IServer[] servers = ProjectPropertyPage.getServersBySupportedModule(this.module);
                if (servers == null || servers.length == 0) {
                    label = new Label(composite, 64);
                    label.setText(Messages.prefProjectNotConfigured);
                    data = new GridData(256);
                    data.horizontalSpan = 2;
                    data.verticalIndent = 5;
                    label.setLayoutData((Object)data);
                } else {
                    label = new Label(composite, 0);
                    label.setText(Messages.prefProjectDefaultServer);
                    data = new GridData(258);
                    data.horizontalSpan = 2;
                    data.verticalIndent = 5;
                    label.setLayoutData((Object)data);
                    this.table = new Table(composite, 2564);
                    data = new GridData(768);
                    data.horizontalSpan = 2;
                    data.horizontalIndent = 15;
                    data.heightHint = 90;
                    this.table.setLayoutData((Object)data);
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(Messages.prefProjectNoServer);
                    int size2 = servers.length;
                    this.count = 0;
                    ILabelProvider labelProvider = ServerUICore.getLabelProvider();
                    int j = 0;
                    while (j < size2) {
                        item = new TableItem(this.table, 0);
                        item.setText(labelProvider.getText((Object)servers[j]));
                        item.setImage(labelProvider.getImage((Object)servers[j]));
                        item.setData((Object)servers[j]);
                        if (servers[j].equals(this.defaultServer)) {
                            this.count = j + 1;
                        }
                        ++j;
                    }
                    labelProvider.dispose();
                    this.table.setSelection(this.count);
                    this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            int index = ProjectPropertyPage.this.table.getSelectionIndex();
                            if (index == 0) {
                                ProjectPropertyPage.this.server = null;
                            } else if (index > 0) {
                                ProjectPropertyPage.this.server = servers[index - 1];
                            }
                        }
                    });
                }
            }
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error creating project property page", e);
            return null;
        }
    }

    protected static IServer[] getServersBySupportedModule(IModule module) {
        if (module == null) {
            return new IServer[0];
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (servers[i].getServerType() != null && servers[i].getServerType().getRuntimeType() != null && ServerUtil.isSupportedModule((IModuleType[])servers[i].getServerType().getRuntimeType().getModuleTypes(), (IModuleType)module.getModuleType())) {
                    list.add(servers[i]);
                }
                ++i;
            }
        }
        IServer[] allServers = new IServer[list.size()];
        list.toArray(allServers);
        return allServers;
    }

    protected void performDefaults() {
        if (this.table != null) {
            this.table.select(this.count);
            this.server = this.defaultServer;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.module != null) {
            try {
                ServerCore.setDefaultServer((IModule)this.module, (IServer)this.server, null);
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "Error setting preferred server", e);
                EclipseUtil.openError(Messages.errorCouldNotSavePreference, e.getStatus());
                return false;
            }
        }
        return super.performOk();
    }
}

