/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.page.NewRuntimeComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class NewRuntimeWizardFragment
extends WizardFragment {
    protected String type;
    protected String version;
    protected String runtimeTypeId;
    protected Map fragmentMap = new HashMap();

    public NewRuntimeWizardFragment() {
    }

    public NewRuntimeWizardFragment(String type, String version, String runtimeTypeId) {
        this.type = type;
        this.version = version;
        this.runtimeTypeId = runtimeTypeId;
    }

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        return new NewRuntimeComposite(parent, wizard, this.getTaskModel(), this.type, this.version, this.runtimeTypeId);
    }

    public List getChildFragments() {
        ArrayList listImpl = new ArrayList();
        this.createChildFragments(listImpl);
        return listImpl;
    }

    protected void createChildFragments(List list) {
        IServerWorkingCopy server;
        if (this.getTaskModel() == null) {
            return;
        }
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (runtime == null) {
            return;
        }
        WizardFragment sub = this.getWizardFragment(runtime.getRuntimeType().getId());
        if (sub != null) {
            list.add(sub);
        }
        if (runtime != null && (server = (IServerWorkingCopy)this.getTaskModel().getObject("server")) != null) {
            if (server.getServerType().hasServerConfiguration() && server instanceof ServerWorkingCopy) {
                ServerWorkingCopy swc = (ServerWorkingCopy)server;
                try {
                    if (swc != null && runtime != null && runtime.getLocation() != null && !runtime.getLocation().isEmpty()) {
                        swc.importRuntimeConfiguration((IRuntime)runtime, null);
                    }
                }
                catch (CoreException coreException) {}
            }
            if ((sub = this.getWizardFragment(server.getServerType().getId())) != null) {
                list.add(sub);
            }
            list.add(WizardTaskUtil.SaveServerFragment);
        }
    }

    protected WizardFragment getWizardFragment(String typeId) {
        WizardFragment fragment;
        try {
            fragment = (WizardFragment)this.fragmentMap.get(typeId);
            if (fragment != null) {
                return fragment;
            }
        }
        catch (Exception exception) {}
        fragment = ServerUIPlugin.getWizardFragment(typeId);
        if (fragment != null) {
            this.fragmentMap.put(typeId, fragment);
        }
        return fragment;
    }
}

