/*******************************************************************************
 * Copyright (c) 2004, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.javascript.core.internal.jsparser.node;



/* This file was generated by SableCC (http://www.sablecc.org/). */

public abstract class Token extends Node {

	private String text;
	private int line;
	private int pos;
	private int lpoffset;
	private boolean containsLineTerminator;

	public boolean getContainsLineTerminator() {
		return containsLineTerminator;
	}

	public int getLine() {
		return line;
	}

	public int getLPOffset() {
		return lpoffset;
	}

	public int getEndLPOffset() {
		return lpoffset + text.length();
	}

	public int getPos() {
		return pos;
	}

	public String getText() {
		return text;
	}

	void removeChild(Node child) {
	}

	void replaceChild(Node oldChild, Node newChild) {
	}

	public void setContainsLineTerminator(boolean clt) {
		this.containsLineTerminator = clt;
	}

	public void setLine(int line) {
		this.line = line;
	}

	public void setLPOffset(int lpoffset) {
		this.lpoffset = lpoffset;
	}

	public void setPos(int pos) {
		this.pos = pos;
	}

	public void setText(String text) {
		this.text = text;
	}

	public String toString() {
		return text /*+ " "*/;
	}
}
