/**
 * <copyright>
 * </copyright>
 *
 * $Id: PaletteInfosAdapterFactory.java,v 1.2 2007/04/16 19:55:16 itrimble Exp $
 */
package org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.internal.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.PaletteInfosPackage
 * @generated
 */
public class PaletteInfosAdapterFactory extends AdapterFactoryImpl {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright (c) 2007 Oracle Corporation";

	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static PaletteInfosPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PaletteInfosAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = PaletteInfosPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch the delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PaletteInfosSwitch modelSwitch =
		new PaletteInfosSwitch() {
			public Object casePaletteInfos(PaletteInfos object) {
				return createPaletteInfosAdapter();
			}
			public Object casePaletteInfo(PaletteInfo object) {
				return createPaletteInfoAdapter();
			}
			public Object caseTagCreationInfo(TagCreationInfo object) {
				return createTagCreationInfoAdapter();
			}
			public Object caseTagCreationTemplate(TagCreationTemplate object) {
				return createTagCreationTemplateAdapter();
			}
			public Object caseTagCreationAttribute(TagCreationAttribute object) {
				return createTagCreationAttributeAdapter();
			}
			public Object defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter(Notifier target) {
		return (Adapter)modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.PaletteInfo <em>Palette Info</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.PaletteInfo
	 * @generated
	 */
	public Adapter createPaletteInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.TagCreationInfo <em>Tag Creation Info</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.TagCreationInfo
	 * @generated
	 */
	public Adapter createTagCreationInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.TagCreationTemplate <em>Tag Creation Template</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.TagCreationTemplate
	 * @generated
	 */
	public Adapter createTagCreationTemplateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.TagCreationAttribute <em>Tag Creation Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.TagCreationAttribute
	 * @generated
	 */
	public Adapter createTagCreationAttributeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.PaletteInfos <em>Palette Infos</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.PaletteInfos
	 * @generated
	 */
	public Adapter createPaletteInfosAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //PaletteInfosAdapterFactory
