/**
 * <copyright>
 * </copyright>
 *
 * $Id: PersistenceContextType.java,v 1.1 2007/05/16 06:42:29 cbridgha Exp $
 */
package org.eclipse.jst.javaee.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Persistence Context Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * 
 * 
 * 	The persistence-context-typeType specifies the transactional
 * 	nature of a persistence context reference.
 * 
 * 	The value of the persistence-context-type element must be
 * 	one of the following:
 * 	    Transaction
 *             Extended
 * 
 *       
 * <!-- end-model-doc -->
 * @see org.eclipse.jst.javaee.core.internal.metadata.JavaeePackage#getPersistenceContextType()
 * @generated
 */
public final class PersistenceContextType extends AbstractEnumerator {
	/**
	 * The '<em><b>Transaction</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Transaction</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #TRANSACTION_LITERAL
	 * @generated
	 * @ordered
	 */
	public static final int TRANSACTION = 0;

	/**
	 * The '<em><b>Extended</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Extended</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXTENDED_LITERAL
	 * @generated
	 * @ordered
	 */
	public static final int EXTENDED = 1;

	/**
	 * The '<em><b>Transaction</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRANSACTION
	 * @generated
	 * @ordered
	 */
	public static final PersistenceContextType TRANSACTION_LITERAL = new PersistenceContextType(TRANSACTION, "Transaction", "Transaction"); //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>Extended</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXTENDED
	 * @generated
	 * @ordered
	 */
	public static final PersistenceContextType EXTENDED_LITERAL = new PersistenceContextType(EXTENDED, "Extended", "Extended"); //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * An array of all the '<em><b>Persistence Context Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final PersistenceContextType[] VALUES_ARRAY =
		new PersistenceContextType[] {
			TRANSACTION_LITERAL,
			EXTENDED_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Persistence Context Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Persistence Context Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static PersistenceContextType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			PersistenceContextType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Persistence Context Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static PersistenceContextType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			PersistenceContextType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Persistence Context Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static PersistenceContextType get(int value) {
		switch (value) {
			case TRANSACTION: return TRANSACTION_LITERAL;
			case EXTENDED: return EXTENDED_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private PersistenceContextType(int value, String name, String literal) {
		super(value, name, literal);
	}

} //PersistenceContextType
