/**
 * <copyright>
 * </copyright>
 *
 * $Id: SessionConfig.java,v 1.1 2007/05/16 06:42:31 cbridgha Exp $
 */
package org.eclipse.jst.javaee.web;

import java.math.BigInteger;

import org.eclipse.jst.javaee.core.JavaEEObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Session Config</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 * 
 * 	The session-configType defines the session parameters
 * 	for this web application.
 * 
 * 	Used in: web-app
 * 
 *       
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.jst.javaee.web.SessionConfig#getSessionTimeout <em>Session Timeout</em>}</li>
 *   <li>{@link org.eclipse.jst.javaee.web.SessionConfig#getId <em>Id</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.jst.javaee.web.internal.metadata.WebPackage#getSessionConfig()
 * @extends JavaEEObject
 * @generated
 */
public interface SessionConfig extends JavaEEObject {
	/**
	 * Returns the value of the '<em><b>Session Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 
	 * 	    The session-timeout element defines the default
	 * 	    session timeout interval for all sessions created
	 * 	    in this web application. The specified timeout
	 * 	    must be expressed in a whole number of minutes.
	 * 	    If the timeout is 0 or less, the container ensures
	 * 	    the default behaviour of sessions is never to time
	 * 	    out. If this element is not specified, the container
	 * 	    must set its default timeout period.
	 * 
	 * 	  
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Session Timeout</em>' attribute.
	 * @see #setSessionTimeout(BigInteger)
	 * @see org.eclipse.jst.javaee.web.internal.metadata.WebPackage#getSessionConfig_SessionTimeout()
	 * @generated
	 */
	BigInteger getSessionTimeout();

	/**
	 * Sets the value of the '{@link org.eclipse.jst.javaee.web.SessionConfig#getSessionTimeout <em>Session Timeout</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Session Timeout</em>' attribute.
	 * @see #getSessionTimeout()
	 * @generated
	 */
	void setSessionTimeout(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.jst.javaee.web.internal.metadata.WebPackage#getSessionConfig_Id()
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.jst.javaee.web.SessionConfig#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

} // SessionConfig