/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.SynchronizedBoolean;

public class SynchronousJpaProjectUpdater
implements JpaProject.Updater {
    protected final JpaProject jpaProject;
    protected final SynchronizedFlags flags;
    protected static final IProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();

    public SynchronousJpaProjectUpdater(JpaProject jpaProject) {
        this.jpaProject = jpaProject;
        this.flags = new SynchronizedFlags();
    }

    public void start() {
        this.flags.start();
        this.update();
    }

    public void update() {
        if (this.flags.updateCanStart()) {
            do {
                this.jpaProject.update(NULL_PROGRESS_MONITOR);
            } while (this.flags.updateMustExecuteAgain());
        }
    }

    public void dispose() {
        this.flags.dispose();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.jpaProject);
    }

    protected static class SynchronizedFlags {
        protected SynchronizedBoolean updating = new SynchronizedBoolean(false, (Object)this);
        protected boolean again = false;
        protected boolean stop = true;

        protected SynchronizedFlags() {
        }

        protected synchronized void start() {
            if (!this.stop) {
                throw new IllegalStateException("The Updater was not stopped.");
            }
            this.stop = false;
        }

        protected synchronized boolean updateCanStart() {
            if (this.stop) {
                return false;
            }
            if (this.updating.isTrue()) {
                this.again = true;
                return false;
            }
            this.updating.setTrue();
            this.again = false;
            return true;
        }

        protected synchronized boolean updateMustExecuteAgain() {
            if (this.stop) {
                return false;
            }
            if (this.again) {
                this.again = false;
                return true;
            }
            this.updating.setFalse();
            return false;
        }

        protected synchronized void dispose() {
            this.stop = true;
            this.again = false;
            try {
                this.updating.waitUntilFalse();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

