/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;

public class MappingTools {
    public static boolean targetEntityIsValid(String targetEntity) {
        if (targetEntity == null) {
            return true;
        }
        int balance = 0;
        StringTokenizer t = new StringTokenizer(targetEntity, ".", true);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (s.indexOf(46) >= 0) {
                if (s.length() > 1) {
                    return false;
                }
                if (--balance >= 0) continue;
                return false;
            }
            ++balance;
        }
        return balance == 1;
    }

    public static String buildJoinTableDefaultName(RelationshipMapping relationshipMapping) {
        if (!relationshipMapping.isRelationshipOwner()) {
            return null;
        }
        String owningTableName = relationshipMapping.getTypeMapping().getTableName();
        if (owningTableName == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        String targetTableName = targetEntity.getTableName();
        if (targetTableName == null) {
            return null;
        }
        return String.valueOf(owningTableName) + "_" + targetTableName;
    }

    public static String buildJoinColumnDefaultName(JoinColumn joinColumn) {
        if (joinColumn.getOwner().joinColumnsSize() != 1) {
            return null;
        }
        String prefix = joinColumn.getOwner().getAttributeName();
        if (prefix == null) {
            prefix = MappingTools.targetEntityName(joinColumn);
        }
        if (prefix == null) {
            return null;
        }
        String targetColumn = joinColumn.getReferencedColumnName();
        if (targetColumn == null) {
            return null;
        }
        return String.valueOf(prefix) + "_" + targetColumn;
    }

    protected static String targetEntityName(JoinColumn joinColumn) {
        Entity targetEntity = joinColumn.getOwner().getTargetEntity();
        return targetEntity == null ? null : targetEntity.getName();
    }

    public static String buildJoinColumnDefaultReferencedColumnName(JoinColumn joinColumn) {
        if (joinColumn.getOwner().joinColumnsSize() != 1) {
            return null;
        }
        return MappingTools.targetPrimaryKeyColumnName(joinColumn);
    }

    protected static String targetPrimaryKeyColumnName(JoinColumn joinColumn) {
        Entity targetEntity = joinColumn.getOwner().getTargetEntity();
        return targetEntity == null ? null : targetEntity.getPrimaryKeyColumnName();
    }

    public static Embeddable getEmbeddableFor(JavaPersistentAttribute persistentAttribute) {
        String qualifiedTypeName = persistentAttribute.getResourcePersistentAttribute().getQualifiedTypeName();
        if (qualifiedTypeName == null) {
            return null;
        }
        PersistentType persistentType = persistentAttribute.getPersistenceUnit().getPersistentType(qualifiedTypeName);
        if (persistentType != null && persistentType.getMappingKey() == "embeddable") {
            return (Embeddable)persistentType.getMapping();
        }
        return null;
    }

    public static ColumnMapping getColumnMapping(String attributeName, Embeddable embeddable) {
        if (attributeName == null || embeddable == null) {
            return null;
        }
        Iterator<PersistentAttribute> stream = embeddable.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            PersistentAttribute persAttribute = stream.next();
            if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof ColumnMapping)) continue;
            return (ColumnMapping)((Object)persAttribute.getMapping());
        }
        return null;
    }
}

