/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.OverrideAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaOverride
extends AbstractJavaJpaContextNode
implements BaseOverride {
    protected String name;
    protected final BaseOverride.Owner owner;
    protected OverrideAnnotation overrideResource;

    public AbstractJavaOverride(JavaJpaContextNode parent, BaseOverride.Owner owner) {
        super(parent);
        this.owner = owner;
    }

    protected void initializeFromResource(OverrideAnnotation overrideResource) {
        this.overrideResource = overrideResource;
        this.name = this.name(overrideResource);
    }

    protected OverrideAnnotation getOverrideResource() {
        return this.overrideResource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.overrideResource.setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void update(OverrideAnnotation overrideResource) {
        this.overrideResource = overrideResource;
        this.setName_(this.name(overrideResource));
    }

    protected String name(OverrideAnnotation overrideResource) {
        return overrideResource.getName();
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    public BaseOverride setVirtual(boolean virtual) {
        return this.getOwner().setVirtual(virtual, this);
    }

    public BaseOverride.Owner getOwner() {
        return this.owner;
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    protected abstract Iterator<String> candidateNames();

    private Iterator<String> candidateNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateNames(), filter);
    }

    private Iterator<String> quotedCandidateNames(Filter<String> filter) {
        return StringTools.quote(this.candidateNames(filter));
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.quotedCandidateNames(filter);
        }
        return null;
    }

    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.overrideResource.nameTouches(pos, astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.overrideResource.getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getName());
    }
}

