/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaUniqueConstraint
extends AbstractJavaJpaContextNode
implements JavaUniqueConstraint {
    protected final List<String> columnNames;
    protected UniqueConstraintAnnotation uniqueConstraintAnnotation;
    protected UniqueConstraint.Owner owner;

    public GenericJavaUniqueConstraint(JavaJpaContextNode parent, UniqueConstraint.Owner owner) {
        super(parent);
        this.owner = owner;
        this.columnNames = new ArrayList<String>();
    }

    public UniqueConstraint.Owner getOwner() {
        return this.owner;
    }

    @Override
    public ListIterator<String> columnNames() {
        return new CloneListIterator(this.columnNames);
    }

    @Override
    public int columnNamesSize() {
        return this.columnNames.size();
    }

    @Override
    public void addColumnName(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.uniqueConstraintAnnotation.addColumnName(index, columnName);
        this.fireItemAdded("columnNamesList", index, columnName);
    }

    protected void addColumnName_(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.fireItemAdded("columnNamesList", index, columnName);
    }

    @Override
    public void removeColumnName(String columnName) {
        this.removeColumnName(this.columnNames.indexOf(columnName));
    }

    @Override
    public void removeColumnName(int index) {
        String removedColumnName = this.columnNames.remove(index);
        this.uniqueConstraintAnnotation.removeColumnName(index);
        this.fireItemRemoved("columnNamesList", index, removedColumnName);
    }

    protected void removeColumnName_(int index) {
        String removedColumnName = this.columnNames.remove(index);
        this.fireItemRemoved("columnNamesList", index, removedColumnName);
    }

    @Override
    public void moveColumnName(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.columnNames, (int)targetIndex, (int)sourceIndex);
        this.uniqueConstraintAnnotation.moveColumnName(targetIndex, sourceIndex);
        this.fireItemMoved("columnNamesList", targetIndex, sourceIndex);
    }

    @Override
    public void initialize(UniqueConstraintAnnotation uniqueConstraintAnnotation) {
        this.uniqueConstraintAnnotation = uniqueConstraintAnnotation;
        this.initializeColumnNames(uniqueConstraintAnnotation);
    }

    protected void initializeColumnNames(UniqueConstraintAnnotation uniqueConstraintAnnotation) {
        ListIterator<String> annotationColumnNames = uniqueConstraintAnnotation.columnNames();
        for (String annotationColumnName : CollectionTools.iterable(annotationColumnNames)) {
            this.columnNames.add(annotationColumnName);
        }
    }

    @Override
    public void update(UniqueConstraintAnnotation uniqueConstraintAnnotation) {
        this.uniqueConstraintAnnotation = uniqueConstraintAnnotation;
        this.updateColumnNames(uniqueConstraintAnnotation);
    }

    protected void updateColumnNames(UniqueConstraintAnnotation uniqueConstraintAnnotation) {
        ListIterator<String> annotationColumnNames = uniqueConstraintAnnotation.columnNames();
        int index = 0;
        for (String annotationColumnName : CollectionTools.iterable(annotationColumnNames)) {
            if (this.columnNamesSize() > index) {
                if (this.columnNames.get(index) != annotationColumnName) {
                    this.addColumnName_(index, annotationColumnName);
                }
            } else {
                this.addColumnName_(index, annotationColumnName);
            }
            ++index;
        }
        while (index < this.columnNamesSize()) {
            this.removeColumnName_(index);
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.uniqueConstraintAnnotation.getTextRange(astRoot);
    }

    private boolean columnNamesTouches(int pos, CompilationUnit astRoot) {
        return this.uniqueConstraintAnnotation.columnNamesTouches(pos, astRoot);
    }

    private Iterator<String> candidateColumnNames() {
        return this.getOwner().candidateUniqueConstraintColumnNames();
    }

    private Iterator<String> candidateColumnNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateColumnNames(), filter);
    }

    private Iterator<String> quotedCandidateColumnNames(Filter<String> filter) {
        return StringTools.quote(this.candidateColumnNames(filter));
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.columnNamesTouches(pos, astRoot)) {
            return this.quotedCandidateColumnNames(filter);
        }
        return null;
    }
}

