/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaVersionMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.VersionAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaVersionMapping
extends AbstractJavaAttributeMapping<VersionAnnotation>
implements JavaVersionMapping {
    protected final JavaColumn column = this.createJavaColumn();
    protected TemporalType temporal;

    public GenericJavaVersionMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected JavaColumn createJavaColumn() {
        return this.getJpaFactory().buildJavaColumn(this, this);
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.initializeFromResource(resourcePersistentAttribute);
        this.column.initializeFromResource(this.getColumnResource());
        this.temporal = this.temporal(this.temporalResource());
    }

    protected TemporalAnnotation temporalResource() {
        return (TemporalAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Temporal");
    }

    @Override
    public ColumnAnnotation getColumnResource() {
        return (ColumnAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Column");
    }

    @Override
    public String getKey() {
        return "version";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Version";
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.Column", "javax.persistence.Temporal"});
    }

    @Override
    public String getDefaultColumnName() {
        return this.getAttributeName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getTableName();
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    @Override
    public TemporalType getTemporal() {
        return this.temporal;
    }

    @Override
    public void setTemporal(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        this.temporalResource().setValue(TemporalType.toJavaResourceModel(newTemporal));
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    @Override
    public void update(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.update(resourcePersistentAttribute);
        this.column.update(this.getColumnResource());
        this.setTemporal(this.temporal(this.temporalResource()));
    }

    protected TemporalType temporal(TemporalAnnotation temporal) {
        return TemporalType.fromJavaResourceModel(temporal.getValue());
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        this.addColumnMessages(messages, astRoot);
    }

    protected void addColumnMessages(List<IMessage> messages, CompilationUnit astRoot) {
        boolean doContinue;
        JavaColumn column = this.getColumn();
        String table = column.getTable();
        boolean bl = doContinue = this.entityOwned() && column.connectionProfileIsActive();
        if (doContinue && this.getTypeMapping().tableNameIsInvalid(table)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.getTableTextRange(astRoot)));
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.getNameTextRange(astRoot)));
        }
    }
}

