/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlJoinColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlUniqueConstraint;
import org.eclipse.jpt.core.resource.common.AbstractJpaEObject;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualXmlJoinTable
extends AbstractJpaEObject
implements XmlJoinTable {
    protected JavaJoinTable javaJoinTable;
    protected boolean metadataComplete;
    protected OrmPersistentAttribute ormPersistentAttribute;

    protected VirtualXmlJoinTable(OrmPersistentAttribute ormPersistentAttribute, JavaJoinTable javaJoinTable, boolean metadataComplete) {
        this.ormPersistentAttribute = ormPersistentAttribute;
        this.javaJoinTable = javaJoinTable;
        this.metadataComplete = metadataComplete;
    }

    protected OrmRelationshipMapping ormRelationshipMapping() {
        return (OrmRelationshipMapping)this.ormPersistentAttribute.getMapping();
    }

    @Override
    public String getName() {
        if (!this.metadataComplete && this.javaJoinTable.getSpecifiedName() != null) {
            return this.javaJoinTable.getSpecifiedName();
        }
        return MappingTools.buildJoinTableDefaultName(this.ormRelationshipMapping());
    }

    @Override
    public void setName(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    @Override
    public String getCatalog() {
        if (this.metadataComplete) {
            return this.javaJoinTable.getDefaultCatalog();
        }
        return this.javaJoinTable.getCatalog();
    }

    @Override
    public void setCatalog(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    @Override
    public String getSchema() {
        if (this.metadataComplete) {
            return this.javaJoinTable.getDefaultSchema();
        }
        return this.javaJoinTable.getSchema();
    }

    @Override
    public void setSchema(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    @Override
    public EList<XmlJoinColumn> getJoinColumns() {
        EObjectContainmentEList joinColumns = new EObjectContainmentEList(XmlJoinColumn.class, (InternalEObject)this, 4);
        for (JavaJoinColumn joinColumn : CollectionTools.iterable(this.javaJoinTable.specifiedJoinColumns())) {
            VirtualXmlJoinColumn xmlJoinColumn = new VirtualXmlJoinColumn(joinColumn, this.metadataComplete);
            joinColumns.add((Object)xmlJoinColumn);
        }
        return joinColumns;
    }

    @Override
    public EList<XmlJoinColumn> getInverseJoinColumns() {
        EObjectContainmentEList inverseJoinColumns = new EObjectContainmentEList(XmlJoinColumn.class, (InternalEObject)this, 5);
        for (JavaJoinColumn joinColumn : CollectionTools.iterable(this.javaJoinTable.specifiedInverseJoinColumns())) {
            VirtualXmlJoinColumn xmlJoinColumn = new VirtualXmlJoinColumn(joinColumn, this.metadataComplete);
            inverseJoinColumns.add((Object)xmlJoinColumn);
        }
        return inverseJoinColumns;
    }

    @Override
    public EList<XmlUniqueConstraint> getUniqueConstraints() {
        EObjectContainmentEList xmlUniqueConstraints = new EObjectContainmentEList(XmlUniqueConstraint.class, (InternalEObject)this, 3);
        for (JavaUniqueConstraint uniqueConstraint : CollectionTools.iterable(this.javaJoinTable.uniqueConstraints())) {
            VirtualXmlUniqueConstraint xmlUniqueConstraint = new VirtualXmlUniqueConstraint(uniqueConstraint, this.metadataComplete);
            xmlUniqueConstraints.add((Object)xmlUniqueConstraint);
        }
        return xmlUniqueConstraints;
    }

    public void update(JavaJoinTable javaJoinTable) {
        this.javaJoinTable = javaJoinTable;
    }

    @Override
    public TextRange getNameTextRange() {
        return null;
    }

    @Override
    public TextRange getCatalogTextRange() {
        return null;
    }

    @Override
    public TextRange getSchemaTextRange() {
        return null;
    }

    @Override
    public boolean isSpecified() {
        return this.javaJoinTable.isSpecified();
    }
}

