/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumArrayDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitArrayAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.CascadeType;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRelationshipMappingAnnotation
extends AbstractResourceAnnotation<Attribute>
implements RelationshipMappingAnnotation {
    private final DeclarationAnnotationElementAdapter<String> targetEntityDeclarationAdapter = this.targetEntityAdapter();
    private final DeclarationAnnotationElementAdapter<String> fetchDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<String[]> cascadeDeclarationAdapter;
    private final AnnotationElementAdapter<String> targetEntityAdapter = this.buildAnnotationElementAdapter(this.targetEntityDeclarationAdapter);
    private final AnnotationElementAdapter<String> fetchAdapter;
    private final AnnotationElementAdapter<String[]> cascadeAdapter;
    private String targetEntity;
    private String fullyQualifiedTargetEntity;
    private FetchType fetch;
    protected boolean cascadeAll;
    protected boolean cascadePersist;
    protected boolean cascadeMerge;
    protected boolean cascadeRemove;
    protected boolean cascadeRefresh;

    public AbstractRelationshipMappingAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, DeclarationAnnotationAdapter daa) {
        super(parent, attribute, daa);
        this.fetchDeclarationAdapter = this.fetchAdapter();
        this.fetchAdapter = this.buildAnnotationElementAdapter(this.fetchDeclarationAdapter);
        this.cascadeDeclarationAdapter = this.cascadeAdapter();
        this.cascadeAdapter = new ShortCircuitArrayAnnotationElementAdapter((Member)attribute, (DeclarationAnnotationElementAdapter<T[]>)this.cascadeDeclarationAdapter);
    }

    protected AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>((Member)this.getMember(), daea);
    }

    protected AnnotationElementAdapter<Boolean> buildBooleanAnnotationElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new ShortCircuitAnnotationElementAdapter<Boolean>((Member)this.getMember(), daea);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> targetEntityAdapter();

    protected abstract DeclarationAnnotationElementAdapter<String[]> cascadeAdapter();

    protected abstract DeclarationAnnotationElementAdapter<String> fetchAdapter();

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.targetEntity = this.targetEntity(astRoot);
        this.fullyQualifiedTargetEntity = this.fullyQualifiedTargetEntity(astRoot);
        this.fetch = this.fetch(astRoot);
        this.initializeCascadeTypes(astRoot);
    }

    protected void initializeCascadeTypes(CompilationUnit astRoot) {
        String[] javaValue = this.cascadeAdapter.getValue(astRoot);
        CascadeType[] cascadeTypes = CascadeType.fromJavaAnnotationValue(javaValue);
        this.cascadeAll = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.ALL));
        this.cascadeMerge = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.MERGE));
        this.cascadePersist = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.PERSIST));
        this.cascadeRefresh = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REFRESH));
        this.cascadeRemove = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REMOVE));
    }

    @Override
    public String getTargetEntity() {
        return this.targetEntity;
    }

    @Override
    public void setTargetEntity(String newTargetEntity) {
        if (this.attributeValueHasNotChanged(this.targetEntity, newTargetEntity)) {
            return;
        }
        String oldTargetEntity = this.targetEntity;
        this.targetEntity = newTargetEntity;
        this.targetEntityAdapter.setValue(newTargetEntity);
        this.firePropertyChanged("targetEntityProperty", oldTargetEntity, newTargetEntity);
    }

    @Override
    public String getFullyQualifiedTargetEntity() {
        return this.fullyQualifiedTargetEntity;
    }

    protected void setFullyQualifiedTargetEntity(String newTargetEntity) {
        String oldTargetEntity = this.fullyQualifiedTargetEntity;
        this.fullyQualifiedTargetEntity = newTargetEntity;
        this.firePropertyChanged("fullyQualifiedTargetEntityProperty", oldTargetEntity, newTargetEntity);
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType newFetch) {
        if (this.attributeValueHasNotChanged((Object)this.fetch, (Object)newFetch)) {
            return;
        }
        FetchType oldFetch = this.fetch;
        this.fetch = newFetch;
        this.fetchAdapter.setValue(FetchType.toJavaAnnotationValue(newFetch));
        this.firePropertyChanged("fetchProperty", (Object)oldFetch, (Object)newFetch);
    }

    @Override
    public boolean isCascadeAll() {
        return this.cascadeAll;
    }

    @Override
    public void setCascadeAll(boolean newCascadeAll) {
        if (this.cascadeAll == newCascadeAll) {
            return;
        }
        boolean oldCascadeAll = this.cascadeAll;
        this.cascadeAll = newCascadeAll;
        this.setCascade(newCascadeAll, CascadeType.ALL);
        this.firePropertyChanged("cascadeAllProperty", oldCascadeAll, newCascadeAll);
    }

    @Override
    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    @Override
    public void setCascadePersist(boolean newCascadePersist) {
        if (this.cascadePersist == newCascadePersist) {
            return;
        }
        boolean oldCascadePersist = this.cascadePersist;
        this.cascadePersist = newCascadePersist;
        this.setCascade(newCascadePersist, CascadeType.PERSIST);
        this.firePropertyChanged("cascadePersistProperty", oldCascadePersist, newCascadePersist);
    }

    @Override
    public boolean isCascadeMerge() {
        return this.cascadeMerge;
    }

    @Override
    public void setCascadeMerge(boolean newCascadeMerge) {
        if (this.cascadeMerge == newCascadeMerge) {
            return;
        }
        boolean oldCascadeMerge = this.cascadeMerge;
        this.cascadeMerge = newCascadeMerge;
        this.setCascade(newCascadeMerge, CascadeType.MERGE);
        this.firePropertyChanged("cascadeMergeProperty", oldCascadeMerge, newCascadeMerge);
    }

    @Override
    public boolean isCascadeRemove() {
        return this.cascadeRemove;
    }

    @Override
    public void setCascadeRemove(boolean newCascadeRemove) {
        if (this.cascadeRemove == newCascadeRemove) {
            return;
        }
        boolean oldCascadeRemove = this.cascadeRemove;
        this.cascadeRemove = newCascadeRemove;
        this.setCascade(newCascadeRemove, CascadeType.REMOVE);
        this.firePropertyChanged("cascadeRemoveProperty", oldCascadeRemove, newCascadeRemove);
    }

    @Override
    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    @Override
    public void setCascadeRefresh(boolean newCascadeRefresh) {
        if (this.cascadeRefresh == newCascadeRefresh) {
            return;
        }
        boolean oldCascadeRefresh = this.cascadeRefresh;
        this.cascadeRefresh = newCascadeRefresh;
        this.setCascade(newCascadeRefresh, CascadeType.REFRESH);
        this.firePropertyChanged("cascadeRefreshProperty", oldCascadeRefresh, newCascadeRefresh);
    }

    private void setCascadeTypes(CascadeType[] cascadeTypes) {
        String[] newJavaValue = CascadeType.toJavaAnnotationValue(cascadeTypes);
        this.cascadeAdapter.setValue(newJavaValue);
    }

    private void setCascade(boolean isSet, CascadeType cascadeType) {
        String[] javaValue = this.cascadeAdapter.getValue();
        CascadeType[] cascadeTypes = CascadeType.fromJavaAnnotationValue(javaValue);
        List cascadeCollection = CollectionTools.list((Object[])cascadeTypes);
        if (cascadeCollection.contains((Object)cascadeType)) {
            if (!isSet) {
                cascadeCollection.remove((Object)cascadeType);
                this.setCascadeTypes(cascadeCollection.toArray(new CascadeType[cascadeCollection.size()]));
            }
        } else if (isSet) {
            cascadeCollection.add(cascadeType);
            this.setCascadeTypes(cascadeCollection.toArray(new CascadeType[cascadeCollection.size()]));
        }
    }

    @Override
    public TextRange getTargetEntityTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.targetEntityDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getFetchTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.fetchDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getCascadeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.cascadeDeclarationAdapter, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setFetch(this.fetch(astRoot));
        this.setTargetEntity(this.targetEntity(astRoot));
        this.setFullyQualifiedTargetEntity(this.fullyQualifiedTargetEntity(astRoot));
        this.updateCascadeFromJava(astRoot);
    }

    protected FetchType fetch(CompilationUnit astRoot) {
        return FetchType.fromJavaAnnotationValue(this.fetchAdapter.getValue(astRoot));
    }

    protected String targetEntity(CompilationUnit astRoot) {
        return this.targetEntityAdapter.getValue(astRoot);
    }

    private void updateCascadeFromJava(CompilationUnit astRoot) {
        String[] javaValue = this.cascadeAdapter.getValue(astRoot);
        CascadeType[] cascadeTypes = CascadeType.fromJavaAnnotationValue(javaValue);
        this.setCascadeAll(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.ALL)));
        this.setCascadeMerge(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.MERGE)));
        this.setCascadePersist(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.PERSIST)));
        this.setCascadeRefresh(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REFRESH)));
        this.setCascadeRemove(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REMOVE)));
    }

    private String fullyQualifiedTargetEntity(CompilationUnit astRoot) {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return JDTTools.resolveFullyQualifiedName(this.targetEntityAdapter.getExpression(astRoot));
    }

    protected static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return AbstractRelationshipMappingAnnotation.buildAnnotationElementAdapter(annotationAdapter, elementName, SimpleTypeStringExpressionConverter.instance());
    }

    protected static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, false, converter);
    }

    protected static DeclarationAnnotationElementAdapter<String> buildFetchAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new EnumDeclarationAnnotationElementAdapter(annotationAdapter, elementName, false);
    }

    protected static DeclarationAnnotationElementAdapter<String[]> buildEnumArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new EnumArrayDeclarationAnnotationElementAdapter(annotationAdapter, elementName, false);
    }
}

