/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.ColumnImpl;
import org.eclipse.jpt.core.internal.resource.java.NullAttributeOverrideColumn;
import org.eclipse.jpt.core.internal.resource.java.OverrideImpl;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAttributeOverride;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

public class AttributeOverrideImpl
extends OverrideImpl
implements NestableAttributeOverride {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AttributeOverride");
    private final MemberAnnotationAdapter columnAdapter = new MemberAnnotationAdapter((Member)this.getMember(), ColumnImpl.buildAttributeOverrideAnnotationAdapter(this.getDeclarationAnnotationAdapter()));
    private ColumnImpl column;

    protected AttributeOverrideImpl(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        if (this.columnAdapter.getAnnotation(astRoot) != null) {
            this.column = ColumnImpl.createAttributeOverrideColumn(this, this.getMember(), this.getDeclarationAnnotationAdapter());
            this.column.initialize(astRoot);
        }
    }

    public String getAnnotationName() {
        return "javax.persistence.AttributeOverride";
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        AttributeOverrideAnnotation oldAttributeOverride = (AttributeOverrideAnnotation)((Object)oldAnnotation);
        if (oldAttributeOverride.getColumn() != null) {
            ColumnAnnotation column = this.addColumn();
            ((NestableAnnotation)((Object)column)).initializeFrom((NestableAnnotation)((Object)oldAttributeOverride.getColumn()));
        }
    }

    public ColumnAnnotation getNonNullColumn() {
        return this.getColumn() != null ? this.getColumn() : new NullAttributeOverrideColumn(this);
    }

    public ColumnAnnotation getColumn() {
        return this.column;
    }

    public ColumnAnnotation addColumn() {
        ColumnImpl column = ColumnImpl.createAttributeOverrideColumn(this, this.getMember(), this.getDeclarationAnnotationAdapter());
        column.newAnnotation();
        this.setColumn(column);
        return column;
    }

    public void removeColumn() {
        this.column.removeAnnotation();
        this.setColumn(null);
    }

    protected void setColumn(ColumnImpl newColumn) {
        ColumnImpl oldColumn = this.column;
        this.column = newColumn;
        this.firePropertyChanged("columnProperty", oldColumn, newColumn);
    }

    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        if (this.columnAdapter.getAnnotation(astRoot) == null) {
            this.setColumn(null);
        } else if (this.getColumn() != null) {
            this.getColumn().updateFromJava(astRoot);
        } else {
            ColumnImpl column = ColumnImpl.createAttributeOverrideColumn(this, this.getMember(), this.getDeclarationAnnotationAdapter());
            column.initialize(astRoot);
            this.setColumn(column);
        }
    }

    static AttributeOverrideImpl createAttributeOverride(JavaResourceNode parent, Member member) {
        return new AttributeOverrideImpl(parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, DECLARATION_ANNOTATION_ADAPTER));
    }

    static AttributeOverrideImpl createNestedAttributeOverride(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = AttributeOverrideImpl.buildNestedDeclarationAnnotationAdapter(index, attributeOverridesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new AttributeOverrideImpl(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(attributeOverridesAdapter, index, "javax.persistence.AttributeOverride");
    }

    public static class AttributeOverrideAnnotationDefinition
    implements AnnotationDefinition {
        private static final AttributeOverrideAnnotationDefinition INSTANCE = new AttributeOverrideAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private AttributeOverrideAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return AttributeOverrideImpl.createAttributeOverride(parent, member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.AttributeOverride";
        }
    }
}

