/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.resource.java.SecondaryTableImpl;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NestableSecondaryTable;
import org.eclipse.jpt.core.resource.java.SecondaryTablesAnnotation;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondaryTablesImpl
extends AbstractResourceAnnotation<Member>
implements SecondaryTablesAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.SecondaryTables");
    private final List<NestableSecondaryTable> secondaryTables = new ArrayList<NestableSecondaryTable>();

    protected SecondaryTablesImpl(JavaResourcePersistentType parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.SecondaryTables";
    }

    @Override
    public String getNestableAnnotationName() {
        return "javax.persistence.SecondaryTable";
    }

    @Override
    public String getElementName() {
        return "value";
    }

    @Override
    public ListIterator<NestableSecondaryTable> nestedAnnotations() {
        return new CloneListIterator(this.secondaryTables);
    }

    @Override
    public int nestedAnnotationsSize() {
        return this.secondaryTables.size();
    }

    @Override
    public NestableSecondaryTable addInternal(int index) {
        SecondaryTableImpl secondaryTable = this.createSecondaryTable(index);
        this.secondaryTables.add(index, secondaryTable);
        return secondaryTable;
    }

    @Override
    public NestableSecondaryTable add(int index) {
        SecondaryTableImpl secondaryTable = this.createSecondaryTable(index);
        this.add(index, secondaryTable);
        return secondaryTable;
    }

    protected void add(int index, NestableSecondaryTable secondaryTable) {
        this.addItemToList(index, secondaryTable, this.secondaryTables, "secondaryTablesList");
    }

    @Override
    public void remove(NestableSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.secondaryTables, "secondaryTablesList");
    }

    @Override
    public void remove(int index) {
        this.removeItemFromList(index, this.secondaryTables, "secondaryTablesList");
    }

    @Override
    public int indexOf(NestableSecondaryTable secondaryTable) {
        return this.secondaryTables.indexOf(secondaryTable);
    }

    @Override
    public NestableSecondaryTable nestedAnnotationAt(int index) {
        return this.secondaryTables.get(index);
    }

    @Override
    public NestableSecondaryTable nestedAnnotationFor(Annotation jdtAnnotation) {
        for (NestableSecondaryTable secondaryTable : this.secondaryTables) {
            if (jdtAnnotation != secondaryTable.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
            return secondaryTable;
        }
        return null;
    }

    @Override
    public void move(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.secondaryTables, "secondaryTablesList");
    }

    @Override
    public void moveInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.secondaryTables, (int)targetIndex, (int)sourceIndex);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this);
    }

    private SecondaryTableImpl createSecondaryTable(int index) {
        return SecondaryTableImpl.createNestedSecondaryTable(this, this.getMember(), index, this.getDeclarationAnnotationAdapter());
    }

    public static class SecondaryTablesAnnotationDefinition
    implements AnnotationDefinition {
        private static final SecondaryTablesAnnotationDefinition INSTANCE = new SecondaryTablesAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private SecondaryTablesAnnotationDefinition() {
        }

        public org.eclipse.jpt.core.resource.java.Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new SecondaryTablesImpl((JavaResourcePersistentType)parent, member);
        }

        public org.eclipse.jpt.core.resource.java.Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.SecondaryTables";
        }
    }
}

